/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.item.EntityFireworkRocket;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableFireworkEffectData;
import org.spongepowered.api.data.manipulator.mutable.FireworkEffectData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.item.FireworkEffect;
import org.spongepowered.common.data.manipulator.mutable.SpongeFireworkEffectData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.processor.common.FireworkUtils;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeListValue;
import org.spongepowered.common.data.value.mutable.SpongeListValue;

public class FireworkEffectDataProcessor
extends AbstractEntitySingleDataProcessor<EntityFireworkRocket, List<FireworkEffect>, ListValue<FireworkEffect>, FireworkEffectData, ImmutableFireworkEffectData> {
    public FireworkEffectDataProcessor() {
        super(EntityFireworkRocket.class, Keys.FIREWORK_EFFECTS);
    }

    @Override
    protected FireworkEffectData createManipulator() {
        return new SpongeFireworkEffectData();
    }

    @Override
    public boolean supports(EntityType entityType) {
        return entityType.equals(EntityTypes.FIREWORK);
    }

    @Override
    protected Optional<List<FireworkEffect>> getVal(EntityFireworkRocket firework) {
        return FireworkUtils.getFireworkEffects(firework);
    }

    @Override
    public Optional<FireworkEffectData> fill(DataContainer container, FireworkEffectData fireworkEffectData) {
        DataUtil.checkDataExists(container, Keys.FIREWORK_EFFECTS.getQuery());
        List<FireworkEffect> effects = container.getSerializableList(Keys.FIREWORK_EFFECTS.getQuery(), FireworkEffect.class).get();
        return Optional.of(fireworkEffectData.set(Keys.FIREWORK_EFFECTS, effects));
    }

    @Override
    protected boolean set(EntityFireworkRocket firework, List<FireworkEffect> effects) {
        return FireworkUtils.setFireworkEffects(firework, effects);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (FireworkUtils.removeFireworkEffects(container)) {
            return DataTransactionResult.successNoData();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    protected ListValue<FireworkEffect> constructValue(List<FireworkEffect> value) {
        return new SpongeListValue<FireworkEffect>(Keys.FIREWORK_EFFECTS, value);
    }

    @Override
    protected ImmutableValue<List<FireworkEffect>> constructImmutableValue(List<FireworkEffect> value) {
        return new ImmutableSpongeListValue<FireworkEffect>(Keys.FIREWORK_EFFECTS, ImmutableList.copyOf(value));
    }
}

