/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutablePotionEffectData;
import org.spongepowered.api.data.manipulator.mutable.PotionEffectData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.common.data.manipulator.mutable.SpongePotionEffectData;
import org.spongepowered.common.data.processor.common.AbstractSingleDataSingleTargetProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeListValue;
import org.spongepowered.common.data.value.mutable.SpongeListValue;

public class PotionEntityPotionDataProcessor
extends AbstractSingleDataSingleTargetProcessor<EntityPotion, List<org.spongepowered.api.effect.potion.PotionEffect>, ListValue<org.spongepowered.api.effect.potion.PotionEffect>, PotionEffectData, ImmutablePotionEffectData> {
    public PotionEntityPotionDataProcessor() {
        super(Keys.POTION_EFFECTS, EntityPotion.class);
    }

    @Override
    protected boolean set(EntityPotion dataHolder, List<org.spongepowered.api.effect.potion.PotionEffect> value) {
        return false;
    }

    @Override
    protected Optional<List<org.spongepowered.api.effect.potion.PotionEffect>> getVal(EntityPotion dataHolder) {
        ItemStack potionItem = dataHolder.func_184543_l();
        if (potionItem == null) {
            return Optional.empty();
        }
        List effects = PotionUtils.func_185189_a((ItemStack)potionItem);
        if (effects == null || effects.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<org.spongepowered.api.effect.potion.PotionEffect> apiEffects = new ArrayList<org.spongepowered.api.effect.potion.PotionEffect>();
        for (PotionEffect potionEffect : effects) {
            apiEffects.add((org.spongepowered.api.effect.potion.PotionEffect)potionEffect);
        }
        return Optional.of(apiEffects);
    }

    @Override
    protected ImmutableValue<List<org.spongepowered.api.effect.potion.PotionEffect>> constructImmutableValue(List<org.spongepowered.api.effect.potion.PotionEffect> value) {
        return new ImmutableSpongeListValue<org.spongepowered.api.effect.potion.PotionEffect>(Keys.POTION_EFFECTS, ImmutableList.copyOf(value));
    }

    @Override
    protected ListValue<org.spongepowered.api.effect.potion.PotionEffect> constructValue(List<org.spongepowered.api.effect.potion.PotionEffect> actualValue) {
        return new SpongeListValue<org.spongepowered.api.effect.potion.PotionEffect>(Keys.POTION_EFFECTS, actualValue);
    }

    @Override
    protected PotionEffectData createManipulator() {
        return new SpongePotionEffectData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (!(container instanceof EntityPotion)) {
            return DataTransactionResult.failNoData();
        }
        Optional<List<org.spongepowered.api.effect.potion.PotionEffect>> effects = this.getVal((EntityPotion)container);
        if (effects.isPresent()) {
            ((EntityPotion)container).func_184541_a(new ItemStack((Item)Items.field_151068_bn, 1, 0));
            return DataTransactionResult.successRemove(this.constructImmutableValue(effects.get()));
        }
        return DataTransactionResult.successNoData();
    }
}

