/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class FlyingSpeedValueProcessor
extends AbstractSpongeValueProcessor<EntityPlayer, Double, Value<Double>> {
    public FlyingSpeedValueProcessor() {
        super(EntityPlayer.class, Keys.FLYING_SPEED);
    }

    @Override
    protected Value<Double> constructValue(Double value) {
        return new SpongeValue<Double>(Keys.FLYING_SPEED, 0.05, value);
    }

    @Override
    protected ImmutableValue<Double> constructImmutableValue(Double value) {
        return this.constructValue(value).asImmutable();
    }

    @Override
    protected boolean set(EntityPlayer container, Double value) {
        container.field_71075_bZ.field_75096_f = value.floatValue();
        container.func_71016_p();
        return true;
    }

    @Override
    protected Optional<Double> getVal(EntityPlayer container) {
        return Optional.of(Double.valueOf(container.field_71075_bZ.func_75093_a()));
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

