/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.item;

import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class UnbreakableValueProcessor
extends AbstractSpongeValueProcessor<ItemStack, Boolean, Value<Boolean>> {
    public UnbreakableValueProcessor() {
        super(ItemStack.class, Keys.UNBREAKABLE);
    }

    @Override
    public boolean supports(ItemStack container) {
        return container.func_77973_b().func_77645_m();
    }

    @Override
    public Value<Boolean> constructValue(Boolean defaultValue) {
        return SpongeValueFactory.getInstance().createValue(Keys.UNBREAKABLE, defaultValue, false);
    }

    @Override
    public boolean set(ItemStack container, Boolean value) {
        if (value.booleanValue()) {
            container.func_77964_b(0);
        }
        if (!container.func_77942_o()) {
            container.func_77982_d(new NBTTagCompound());
        }
        container.func_77978_p().func_74757_a("Unbreakable", value.booleanValue());
        return true;
    }

    @Override
    public Optional<Boolean> getVal(ItemStack container) {
        if (container.func_77942_o() && container.func_77978_p().func_74764_b("Unbreakable")) {
            return Optional.of(container.func_77978_p().func_74767_n("Unbreakable"));
        }
        return Optional.of(false);
    }

    @Override
    public ImmutableValue<Boolean> constructImmutableValue(Boolean value) {
        return this.constructValue(value).asImmutable();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

