/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.particle;

import com.google.common.base.MoreObjects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.spongepowered.api.effect.particle.ParticleOption;
import org.spongepowered.common.SpongeCatalogType;

public class SpongeParticleOption<V>
extends SpongeCatalogType
implements ParticleOption<V> {
    private final String name;
    private final Class<V> valueType;
    @Nullable
    private final Function<V, IllegalArgumentException> valueValidator;

    public SpongeParticleOption(String id, String name, Class<V> valueType, @Nullable Function<V, IllegalArgumentException> valueValidator) {
        super(id);
        this.valueValidator = valueValidator;
        this.valueType = valueType;
        this.name = name;
    }

    public SpongeParticleOption(String id, String name, Class<V> valueType) {
        this(id, name, valueType, null);
    }

    @Nullable
    public IllegalArgumentException validateValue(V value) {
        if (this.valueValidator != null) {
            return this.valueValidator.apply(value);
        }
        return null;
    }

    @Override
    public Class<V> getValueType() {
        return this.valueType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().omitNullValues().add("valueType", this.valueType);
    }
}

