/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.function.Consumer;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;

final class CauseStack {
    private static final PhaseContext EMPTY = PhaseContext.start().complete();
    static final PhaseData EMPTY_DATA = new PhaseData(EMPTY, GeneralPhase.State.COMPLETE);
    private static final int DEFAULT_QUEUE_SIZE = 16;
    private final Deque<PhaseData> states;

    CauseStack() {
        this(16);
    }

    private CauseStack(int size) {
        this.states = new ArrayDeque<PhaseData>(size);
    }

    PhaseData peek() {
        PhaseData phase = this.states.peek();
        return phase == null ? EMPTY_DATA : phase;
    }

    IPhaseState peekState() {
        PhaseData peek = this.states.peek();
        return peek == null ? GeneralPhase.State.COMPLETE : peek.state;
    }

    PhaseContext peekContext() {
        PhaseData peek = this.states.peek();
        return peek == null ? EMPTY : peek.context;
    }

    PhaseData pop() {
        return this.states.pop();
    }

    private CauseStack push(PhaseData tuple) {
        Preconditions.checkNotNull((Object)tuple, (Object)"Tuple cannot be null!");
        Preconditions.checkArgument((boolean)tuple.context.isComplete(), (String)"Phase context must be complete: %s", (Object)tuple);
        this.states.push(tuple);
        return this;
    }

    CauseStack push(IPhaseState state, PhaseContext context) {
        return this.push(new PhaseData(context, state));
    }

    public void forEach(Consumer<PhaseData> consumer) {
        this.states.forEach(consumer::accept);
    }

    public boolean isEmpty() {
        return this.states.isEmpty();
    }

    public int size() {
        return this.states.size();
    }

    public int hashCode() {
        return Objects.hash(this.states);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CauseStack other = (CauseStack)obj;
        return Objects.equals(this.states, other.states);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("states", this.states).toString();
    }
}

