/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.block;

import org.spongepowered.api.entity.Entity;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.TrackingPhase;
import org.spongepowered.common.event.tracking.phase.block.BlockDecayPhaseState;
import org.spongepowered.common.event.tracking.phase.block.BlockDropItemsPhaseState;
import org.spongepowered.common.event.tracking.phase.block.BlockPhaseState;
import org.spongepowered.common.event.tracking.phase.block.DispensePhaseState;
import org.spongepowered.common.event.tracking.phase.block.PistonMovingPhaseState;
import org.spongepowered.common.event.tracking.phase.block.RestoringBlockPhaseState;

public final class BlockPhase
extends TrackingPhase {
    public static BlockPhase getInstance() {
        return Holder.INSTANCE;
    }

    private BlockPhase() {
    }

    @Override
    public boolean requiresBlockCapturing(IPhaseState currentState) {
        return currentState != State.RESTORING_BLOCKS;
    }

    @Override
    public boolean allowEntitySpawns(IPhaseState currentState) {
        return ((BlockPhaseState)currentState).allowsSpawns();
    }

    @Override
    public void unwind(IPhaseState state, PhaseContext phaseContext) {
        ((BlockPhaseState)state).unwind(phaseContext);
    }

    @Override
    public boolean spawnEntityOrCapture(IPhaseState phaseState, PhaseContext context, Entity entity, int chunkX, int chunkZ) {
        return this.allowEntitySpawns(phaseState) ? context.getCapturedEntities().add(entity) : super.spawnEntityOrCapture(phaseState, context, entity, chunkX, chunkZ);
    }

    @Override
    public boolean isRestoring(IPhaseState state, PhaseContext phaseContext, int updateFlag) {
        return state == State.RESTORING_BLOCKS && (updateFlag & 1) == 0;
    }

    private static final class Holder {
        static final BlockPhase INSTANCE = new BlockPhase();

        private Holder() {
        }
    }

    public static final class State {
        public static final IPhaseState BLOCK_DECAY = new BlockDecayPhaseState();
        public static final IPhaseState RESTORING_BLOCKS = new RestoringBlockPhaseState();
        public static final IPhaseState DISPENSE = new DispensePhaseState();
        public static final IPhaseState BLOCK_DROP_ITEMS = new BlockDropItemsPhaseState();
        public static final IPhaseState BLOCK_ADDED = null;
        public static final IPhaseState BLOCK_BREAK = null;
        public static final IPhaseState PISTON_MOVING = new PistonMovingPhaseState();

        private State() {
        }
    }
}

