/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketClickWindow;
import net.minecraft.network.play.client.CPacketHeldItemChange;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.network.play.client.CPacketResourcePackStatus;
import net.minecraft.network.play.client.CPacketUseEntity;
import net.minecraft.network.play.server.SPacketHeldItemChange;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.AffectEntityEvent;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.entity.living.humanoid.player.ResourcePackStatusEvent;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.event.item.inventory.ClickInventoryEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.event.item.inventory.InteractInventoryEvent;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.ItemDropData;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.DropItemWithHotkeyState;
import org.spongepowered.common.event.tracking.phase.packet.IPacketState;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.interfaces.IMixinContainer;
import org.spongepowered.common.interfaces.IMixinPacketResourcePackSend;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayerMP;
import org.spongepowered.common.interfaces.network.IMixinNetHandlerPlayServer;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.item.inventory.util.ContainerUtil;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.registry.type.ItemTypeRegistryModule;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;
import org.spongepowered.common.util.VecHelper;

@FunctionalInterface
public interface PacketFunction {
    public static final PacketFunction IGNORED = (packet, state, player, context) -> {};
    public static final PacketFunction STOP_SLEEPING = (packet, state, player, context) -> {
        if (state == PacketPhase.General.STOP_SLEEPING) {
            List<BlockSnapshot> capturedBlocks = context.getCapturedBlocks();
            TrackingUtil.processBlockCaptures(capturedBlocks, PacketPhase.General.STOP_SLEEPING, context);
        }
    };
    public static final PacketFunction USE_ENTITY = (packet, state, player, context) -> {
        CPacketUseEntity useEntityPacket = (CPacketUseEntity)packet;
        net.minecraft.entity.Entity entity = useEntityPacket.func_149564_a(player.field_70170_p);
        if (entity == null) {
            return;
        }
        World spongeWorld = EntityUtil.getSpongeWorld((net.minecraft.entity.Entity)player);
        EntityUtil.toMixin(entity).setNotifier(player.func_110124_au());
        if (state == PacketPhase.General.ATTACK_ENTITY) {
            context.getCapturedItemsSupplier().ifPresentAndNotEmpty(items -> {
                PrettyPrinter printer = new PrettyPrinter(60);
                printer.add("Processing Attack Entity").centre().hr();
                printer.add("There are some captured items after the entity was destructed!");
                printer.addWrapped(60, "%s : %s", "Items captured", items);
                printer.add("Stacktrace:");
                printer.add(new Exception("Stack trace"));
                printer.trace(System.err, SpongeImpl.getLogger(), Level.TRACE);
            });
            context.getCapturedBlockSupplier().ifPresentAndNotEmpty(blocks -> TrackingUtil.processBlockCaptures(blocks, state, context));
            context.getCapturedEntityDropSupplier().ifPresentAndNotEmpty(map -> {
                for (Map.Entry entry : map.asMap().entrySet()) {
                    UUID key = (UUID)entry.getKey();
                    Optional<Entity> affectedEntity = spongeWorld.getEntity(key);
                    if (!affectedEntity.isPresent()) continue;
                    Collection itemStacks = (Collection)entry.getValue();
                    if (itemStacks.isEmpty()) {
                        return;
                    }
                    ArrayList items = new ArrayList();
                    items.addAll(itemStacks);
                    if (items.isEmpty()) continue;
                    CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();
                    Throwable throwable = null;
                    try {
                        List itemEntities = items.stream().map(data -> data.create((WorldServer)player.field_70170_p)).map(EntityUtil::fromNative).collect(Collectors.toList());
                        Sponge.getCauseStackManager().pushCause(player);
                        Sponge.getCauseStackManager().pushCause(affectedEntity.get());
                        Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.DROPPED_ITEM);
                        DropItemEvent.Destruct destruct = SpongeEventFactory.createDropItemEventDestruct(Sponge.getCauseStackManager().getCurrentCause(), itemEntities);
                        SpongeImpl.postEvent(destruct);
                        if (destruct.isCancelled()) continue;
                        PacketFunction.processSpawnedEntities(player, destruct);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (frame == null) continue;
                        if (throwable != null) {
                            try {
                                frame.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        frame.close();
                    }
                }
            });
            context.getCapturedEntityItemDropSupplier().ifPresentAndNotEmpty(map -> {
                try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                    Sponge.getCauseStackManager().pushCause(player);
                    Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.DROPPED_ITEM);
                    for (Map.Entry entry : map.asMap().entrySet()) {
                        UUID key = (UUID)entry.getKey();
                        Optional<Entity> attackedEntities = spongeWorld.getEntity(key);
                        if (!attackedEntities.isPresent()) continue;
                        List items = ((Collection)entry.getValue()).stream().map(EntityUtil::fromNative).collect(Collectors.toList());
                        DropItemEvent.Destruct destruct = SpongeEventFactory.createDropItemEventDestruct(Sponge.getCauseStackManager().getCurrentCause(), items);
                        SpongeImpl.postEvent(destruct);
                        if (destruct.isCancelled()) continue;
                        PacketFunction.processSpawnedEntities(player, destruct);
                    }
                }
            });
        } else if (state == PacketPhase.General.INTERACT_ENTITY) {
            context.getCapturedBlockSupplier().ifPresentAndNotEmpty(blocks -> {
                PrettyPrinter printer = new PrettyPrinter(80);
                printer.add("Processing Interact Entity").centre().hr();
                printer.add("The blocks captured are:");
                for (BlockSnapshot blockSnapshot : blocks) {
                    printer.add("  Block: %s", blockSnapshot);
                }
                printer.trace(System.err);
            });
            context.getCapturedEntitySupplier().ifPresentAndNotEmpty(entities -> {
                PrettyPrinter printer = new PrettyPrinter(80);
                printer.add("Processing Interact Entity").centre().hr();
                printer.add("The entities captured are:");
                for (Entity capturedEntity : entities) {
                    printer.add("  Entity: %s", capturedEntity);
                }
                printer.trace(System.err);
            });
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                Sponge.getCauseStackManager().pushCause(player);
                Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.PLACEMENT);
                context.getCapturedItemsSupplier().ifPresentAndNotEmpty(entities -> {
                    List items = entities.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
                    SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), items);
                    SpongeImpl.postEvent(event);
                    if (!event.isCancelled()) {
                        PacketFunction.processSpawnedEntities(player, event);
                    }
                });
            }
            context.getCapturedEntityDropSupplier().ifPresentAndNotEmpty(map -> {
                PrettyPrinter printer = new PrettyPrinter(80);
                printer.add("Processing Interact Entity").centre().hr();
                printer.add("The item stacks captured are: ");
                for (Map.Entry entry : map.asMap().entrySet()) {
                    printer.add("  - Entity with UUID: %s", entry.getKey());
                    for (ItemDropData stack : (Collection)entry.getValue()) {
                        printer.add("    - %s", stack);
                    }
                }
                printer.trace(System.err);
            });
        } else if (state == PacketPhase.General.INTERACT_AT_ENTITY) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                Sponge.getCauseStackManager().pushCause(player);
                Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.PLACEMENT);
                context.getCapturedEntitySupplier().ifPresentAndNotEmpty(entities -> {
                    SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), entities);
                    SpongeImpl.postEvent(event);
                    if (!event.isCancelled()) {
                        PacketFunction.processSpawnedEntities(player, event);
                    }
                });
                context.getCapturedItemsSupplier().ifPresentAndNotEmpty(entities -> {
                    List items = entities.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
                    SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), items);
                    SpongeImpl.postEvent(event);
                    if (!event.isCancelled()) {
                        PacketFunction.processSpawnedEntities(player, event);
                    }
                });
                context.getCapturedEntityDropSupplier().ifPresentAndNotEmpty(map -> {
                    PrettyPrinter printer = new PrettyPrinter(80);
                    printer.add("Processing Interact At Entity").centre().hr();
                    printer.add("The item stacks captured are: ");
                    for (Map.Entry entry : map.asMap().entrySet()) {
                        printer.add("  - Entity with UUID: %s", entry.getKey());
                        for (ItemDropData stack : (Collection)entry.getValue()) {
                            printer.add("    - %s", stack);
                        }
                    }
                    printer.trace(System.err);
                });
                context.getCapturedEntityItemDropSupplier().ifPresentAndNotEmpty(map -> {
                    for (Map.Entry entry : map.asMap().entrySet()) {
                        List entities;
                        UUID entityUuid = (UUID)entry.getKey();
                        net.minecraft.entity.Entity entityFromUuid = player.func_71121_q().func_175733_a(entityUuid);
                        if (entityFromUuid == null || (entities = ((Collection)entry.getValue()).stream().map(EntityUtil::fromNative).collect(Collectors.toList())).isEmpty()) continue;
                        DropItemEvent.Custom event = SpongeEventFactory.createDropItemEventCustom(Sponge.getCauseStackManager().getCurrentCause(), entities);
                        SpongeImpl.postEvent(event);
                        if (event.isCancelled()) continue;
                        PacketFunction.processSpawnedEntities(player, event);
                    }
                });
                context.getCapturedItemStackSupplier().ifPresentAndNotEmpty(drops -> {
                    List items = drops.stream().map(drop -> drop.create(player.func_71121_q())).collect(Collectors.toList());
                    List entities = items.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
                    if (!entities.isEmpty()) {
                        DropItemEvent.Custom event = SpongeEventFactory.createDropItemEventCustom(Sponge.getCauseStackManager().getCurrentCause(), entities);
                        SpongeImpl.postEvent(event);
                        if (!event.isCancelled()) {
                            PacketFunction.processSpawnedEntities(player, event);
                        }
                    }
                });
            }
        }
        context.getCapturedBlockSupplier().ifPresentAndNotEmpty(snapshots -> TrackingUtil.processBlockCaptures(snapshots, state, context));
    };
    public static final PacketFunction ACTION = (packet, state, player, context) -> {
        org.spongepowered.api.item.inventory.ItemStack usedStack = context.getExtra("ItemUsed", org.spongepowered.api.item.inventory.ItemStack.class);
        ItemStackSnapshot usedSnapshot = ItemStackUtil.snapshotOf(usedStack);
        Entity spongePlayer = EntityUtil.fromNative((net.minecraft.entity.Entity)player);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(spongePlayer);
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.DROPPED_ITEM);
            if (state == PacketPhase.Inventory.DROP_ITEM_WITH_HOTKEY) {
                context.getCapturedBlockSupplier().ifPresentAndNotEmpty(blocks -> TrackingUtil.processBlockCaptures(blocks, state, context));
                context.getCapturedItemsSupplier().ifPresentAndNotEmpty(items -> {
                    ArrayList<Entity> entities = new ArrayList<Entity>();
                    for (EntityItem item : items) {
                        entities.add(EntityUtil.fromNative((net.minecraft.entity.Entity)item));
                    }
                    CPacketPlayerDigging packetIn = context.getRequiredExtra("Packet", CPacketPlayerDigging.class);
                    CPacketPlayerDigging.Action action = packetIn.func_180762_c();
                    int usedButton = action == CPacketPlayerDigging.Action.DROP_ITEM ? 0 : 1;
                    Transaction<ItemStackSnapshot> cursorTrans = new Transaction<ItemStackSnapshot>(ItemStackSnapshot.NONE, ItemStackSnapshot.NONE);
                    IMixinContainer mixinContainer = ContainerUtil.toMixin(player.field_71070_bA);
                    List<SlotTransaction> slotTrans = mixinContainer.getCapturedTransactions();
                    ClickInventoryEvent dropItemEvent = ((DropItemWithHotkeyState)state).createInventoryEvent(player, ContainerUtil.fromNative(player.field_71070_bA), (Transaction)cursorTrans, (List)Lists.newArrayList(slotTrans), entities, usedButton);
                    SpongeImpl.postEvent(dropItemEvent);
                    if (!dropItemEvent.isCancelled() || PacketPhaseUtil.allTransactionsInvalid(dropItemEvent.getTransactions())) {
                        PacketFunction.processSpawnedEntities(player, (SpawnEntityEvent)((Object)dropItemEvent));
                    } else {
                        ((IMixinEntityPlayerMP)player).restorePacketItem(EnumHand.MAIN_HAND);
                    }
                    slotTrans.clear();
                    mixinContainer.setCaptureInventory(false);
                });
                context.getCapturedEntityDropSupplier().ifPresentAndNotEmpty(itemMapping -> {});
            } else if (state == PacketPhase.Inventory.DROP_INVENTORY) {
                context.getCapturedBlockSupplier().ifPresentAndNotEmpty(blocks -> TrackingUtil.processBlockCaptures(blocks, state, context));
                context.getCapturedItemsSupplier().ifPresentAndNotEmpty(items -> {
                    ArrayList<Entity> entities = new ArrayList<Entity>();
                    for (EntityItem item : items) {
                        entities.add(EntityUtil.fromNative((net.minecraft.entity.Entity)item));
                    }
                    DropItemEvent.Dispense dropItemEvent = SpongeEventFactory.createDropItemEventDispense(Sponge.getCauseStackManager().getCurrentCause(), entities);
                    SpongeImpl.postEvent(dropItemEvent);
                    if (!dropItemEvent.isCancelled()) {
                        PacketFunction.processSpawnedEntities(player, dropItemEvent);
                    }
                });
            } else if (state == PacketPhase.General.INTERACTION) {
                if (!context.getCapturedBlockSupplier().isEmpty()) {
                    if (!TrackingUtil.processBlockCaptures(context.getCapturedBlocks(), state, context)) {
                        return;
                    }
                } else {
                    context.getBlockItemDropSupplier().ifPresentAndNotEmpty(map -> {
                        List<BlockSnapshot> capturedBlocks = context.getCapturedBlocks();
                        if (ShouldFire.DROP_ITEM_EVENT_DESTRUCT) {
                            for (BlockSnapshot blockChange : capturedBlocks) {
                                Location<World> location = blockChange.getLocation().get();
                                Vector3d position = location.getPosition();
                                BlockPos blockPos = VecHelper.toBlockPos(position);
                                List entityItems = map.get((Object)blockPos);
                                if (entityItems.isEmpty()) continue;
                                List items = entityItems.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
                                DropItemEvent.Destruct event = SpongeEventFactory.createDropItemEventDestruct(Sponge.getCauseStackManager().getCurrentCause(), items);
                                SpongeImpl.postEvent(event);
                                if (event.isCancelled()) continue;
                                PacketFunction.processSpawnedEntities(player, event);
                            }
                        } else {
                            for (BlockSnapshot blockChange : capturedBlocks) {
                                Location<World> location = blockChange.getLocation().get();
                                Vector3d position = location.getPosition();
                                BlockPos blockPos = VecHelper.toBlockPos(position);
                                List entityItems = map.get((Object)blockPos);
                                if (entityItems.isEmpty()) continue;
                                PacketFunction.processEntities(player, entityItems);
                            }
                        }
                    });
                }
                context.getCapturedItemsSupplier().ifPresentAndNotEmpty(items -> {
                    if (items.isEmpty()) {
                        return;
                    }
                    ArrayList<Entity> entities = new ArrayList<Entity>();
                    for (EntityItem item : items) {
                        entities.add(EntityUtil.fromNative((net.minecraft.entity.Entity)item));
                    }
                    DropItemEvent.Dispense dispense = SpongeEventFactory.createDropItemEventDispense(Sponge.getCauseStackManager().getCurrentCause(), entities);
                    SpongeImpl.postEvent(dispense);
                    if (!dispense.isCancelled()) {
                        PacketFunction.processSpawnedEntities(player, dispense);
                    }
                });
                context.getCapturedEntityDropSupplier().ifPresentAndNotEmpty(map -> {
                    if (map.isEmpty()) {
                        return;
                    }
                    PrettyPrinter printer = new PrettyPrinter(80);
                    printer.add("Processing Interaction").centre().hr();
                    printer.add("The item stacks captured are: ");
                    for (Map.Entry entry : map.asMap().entrySet()) {
                        printer.add("  - Entity with UUID: %s", entry.getKey());
                        for (ItemDropData stack : (Collection)entry.getValue()) {
                            printer.add("    - %s", stack);
                        }
                    }
                    printer.trace(System.err);
                });
                context.getCapturedEntitySupplier().ifPresentAndNotEmpty(arg_0 -> PacketFunction.lambda$null$27(usedSnapshot, player, arg_0));
            }
            IMixinContainer mixinContainer = ContainerUtil.toMixin(player.field_71070_bA);
            mixinContainer.setCaptureInventory(false);
            mixinContainer.getCapturedTransactions().clear();
        }
    };
    public static final PacketFunction CREATIVE = (packet, state, player, context) -> context.getCapturedItemsSupplier().ifPresentAndNotEmpty(items -> {
        if (items.isEmpty()) {
            return;
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.DROPPED_ITEM);
            Sponge.getCauseStackManager().pushCause(player);
            ArrayList<Entity> entities = new ArrayList<Entity>();
            for (EntityItem item : items) {
                entities.add(EntityUtil.fromNative((net.minecraft.entity.Entity)item));
            }
            DropItemEvent.Dispense dispense = SpongeEventFactory.createDropItemEventDispense(Sponge.getCauseStackManager().getCurrentCause(), entities);
            SpongeImpl.postEvent(dispense);
            if (!dispense.isCancelled()) {
                PacketFunction.processSpawnedEntities(player, dispense);
            }
        }
    });
    public static final PacketFunction INVENTORY = (packet, state, player, context) -> {
        IMixinContainer mixinContainer = ContainerUtil.toMixin(player.field_71070_bA);
        if (!mixinContainer.capturingInventory()) {
            mixinContainer.getCapturedTransactions().clear();
            return;
        }
        CPacketClickWindow packetIn = context.getRequiredExtra("Packet", CPacketClickWindow.class);
        ItemStackSnapshot lastCursor = context.getRequiredExtra("Cursor", ItemStackSnapshot.class);
        ItemStackSnapshot newCursor = ItemStackUtil.snapshotOf(player.field_71071_by.func_70445_o());
        Transaction<ItemStackSnapshot> transaction = new Transaction<ItemStackSnapshot>(lastCursor, newCursor);
        Container openContainer = player.field_71070_bA;
        List<SlotTransaction> slotTransactions = mixinContainer.getCapturedTransactions();
        int usedButton = packetIn.func_149543_e();
        ArrayList<Entity> capturedItems = new ArrayList<Entity>();
        for (EntityItem entityItem : context.getCapturedItems()) {
            capturedItems.add(EntityUtil.fromNative((net.minecraft.entity.Entity)entityItem));
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(player);
            Sponge.getCauseStackManager().pushCause(openContainer);
            ClickInventoryEvent inventoryEvent = state instanceof BasicInventoryPacketState ? ((BasicInventoryPacketState)state).createInventoryEvent(player, ContainerUtil.fromNative(openContainer), transaction, Lists.newArrayList(slotTransactions), capturedItems, usedButton) : null;
            if (mixinContainer.getCapturedTransactions().isEmpty() && capturedItems.isEmpty()) {
                mixinContainer.setCaptureInventory(false);
                return;
            }
            if (inventoryEvent != null) {
                if (inventoryEvent instanceof AffectEntityEvent && ((AffectEntityEvent)((Object)inventoryEvent)).getEntities().isEmpty()) {
                    slotTransactions.clear();
                    mixinContainer.setCaptureInventory(false);
                    return;
                }
                if (!(inventoryEvent instanceof ClickInventoryEvent.Drag)) {
                    PacketPhaseUtil.validateCapturedTransactions(packetIn.func_149544_d(), openContainer, inventoryEvent.getTransactions());
                }
                SpongeImpl.postEvent(inventoryEvent);
                if (inventoryEvent.isCancelled() || PacketPhaseUtil.allTransactionsInvalid(inventoryEvent.getTransactions())) {
                    if (inventoryEvent instanceof ClickInventoryEvent.Drop) {
                        capturedItems.clear();
                    }
                    PacketPhaseUtil.handleCustomCursor(player, inventoryEvent.getCursorTransaction().getOriginal());
                    PacketPhaseUtil.handleSlotRestore(player, openContainer, inventoryEvent.getTransactions(), true);
                } else {
                    PacketPhaseUtil.handleSlotRestore(player, openContainer, inventoryEvent.getTransactions(), false);
                    if (!inventoryEvent.getCursorTransaction().isValid()) {
                        PacketPhaseUtil.handleCustomCursor(player, inventoryEvent.getCursorTransaction().getOriginal());
                    } else if (inventoryEvent.getCursorTransaction().getCustom().isPresent()) {
                        PacketPhaseUtil.handleCustomCursor(player, inventoryEvent.getCursorTransaction().getFinal());
                    } else if (inventoryEvent instanceof ClickInventoryEvent.Drag) {
                        int increment = slotTransactions.stream().filter(t -> !t.isValid()).collect(Collectors.summingInt(t -> ((ItemStackSnapshot)t.getFinal()).getQuantity()));
                        org.spongepowered.api.item.inventory.ItemStack cursor = inventoryEvent.getCursorTransaction().getFinal().createStack();
                        cursor.setQuantity(cursor.getQuantity() + increment);
                        PacketPhaseUtil.handleCustomCursor(player, cursor.createSnapshot());
                    } else if (inventoryEvent instanceof ClickInventoryEvent.Double && !(inventoryEvent instanceof ClickInventoryEvent.Shift)) {
                        int decrement = slotTransactions.stream().filter(t -> !t.isValid()).collect(Collectors.summingInt(t -> ((ItemStackSnapshot)t.getOriginal()).getQuantity()));
                        org.spongepowered.api.item.inventory.ItemStack cursor = inventoryEvent.getCursorTransaction().getFinal().createStack();
                        cursor.setQuantity(cursor.getQuantity() - decrement);
                        PacketPhaseUtil.handleCustomCursor(player, cursor.createSnapshot());
                    }
                    if (inventoryEvent instanceof SpawnEntityEvent) {
                        PacketFunction.processSpawnedEntities(player, (SpawnEntityEvent)((Object)inventoryEvent));
                    } else if (!context.getCapturedEntitySupplier().isEmpty()) {
                        SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), context.getCapturedEntities());
                        SpongeImpl.postEvent(spawnEntityEvent);
                        if (!spawnEntityEvent.isCancelled()) {
                            PacketFunction.processSpawnedEntities(player, spawnEntityEvent);
                        }
                    }
                }
            }
        }
        slotTransactions.clear();
        mixinContainer.setCaptureInventory(false);
    };
    public static final PacketFunction USE_ITEM = (packet, state, player, context) -> {
        org.spongepowered.api.item.inventory.ItemStack itemStack = context.getRequiredExtra("ItemUsed", org.spongepowered.api.item.inventory.ItemStack.class);
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(itemStack);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(player);
            Sponge.getCauseStackManager().pushCause(snapshot);
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, itemStack.getItem() == ItemTypes.SPAWN_EGG ? InternalSpawnTypes.SPAWN_EGG : InternalSpawnTypes.PLACEMENT);
            context.getCapturedEntitySupplier().ifPresentAndNotEmpty(entities -> {
                SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), entities);
                SpongeImpl.postEvent(spawnEntityEvent);
                if (!spawnEntityEvent.isCancelled()) {
                    PacketFunction.processSpawnedEntities(player, spawnEntityEvent);
                }
            });
        }
        context.getCapturedBlockSupplier().ifPresentAndNotEmpty(originalBlocks -> TrackingUtil.processBlockCaptures(originalBlocks, state, context));
    };
    public static final PacketFunction PLACE_BLOCK = (packet, state, player, context) -> {
        if (state == PacketPhase.General.INVALID) {
            return;
        }
        IMixinWorldServer mixinWorld = (IMixinWorldServer)player.field_70170_p;
        org.spongepowered.api.item.inventory.ItemStack itemStack = context.getRequiredExtra("ItemUsed", org.spongepowered.api.item.inventory.ItemStack.class);
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(itemStack);
        context.getCapturedEntitySupplier().ifPresentAndNotEmpty(entities -> {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                Sponge.getCauseStackManager().pushCause(player);
                Sponge.getCauseStackManager().pushCause(snapshot);
                Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.SPAWN_EGG);
                SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), entities);
                SpongeImpl.postEvent(spawnEntityEvent);
                if (!spawnEntityEvent.isCancelled()) {
                    PacketFunction.processSpawnedEntities(player, spawnEntityEvent);
                }
            }
        });
        context.getCapturedBlockSupplier().ifPresentAndNotEmpty(originalBlocks -> {
            Sponge.getCauseStackManager().pushCause(player);
            boolean success = TrackingUtil.processBlockCaptures(originalBlocks, state, context);
            if (!success && snapshot != ItemTypeRegistryModule.NONE_SNAPSHOT) {
                Sponge.getCauseStackManager().pushCause(player);
                EnumHand hand = ((CPacketPlayerTryUseItemOnBlock)packet).func_187022_c();
                PacketPhaseUtil.handlePlayerSlotRestore(player, (ItemStack)itemStack, hand);
            }
            Sponge.getCauseStackManager().popCause();
        });
        context.getCapturedItemStackSupplier().ifPresentAndNotEmpty(drops -> {
            List entities = drops.stream().map(drop -> drop.create(player.func_71121_q())).map(EntityUtil::fromNative).collect(Collectors.toList());
            if (!entities.isEmpty()) {
                try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                    Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
                    Sponge.getCauseStackManager().pushCause(player);
                    DropItemEvent.Custom event = SpongeEventFactory.createDropItemEventCustom(Sponge.getCauseStackManager().getCurrentCause(), entities);
                    SpongeImpl.postEvent(event);
                    if (!event.isCancelled()) {
                        for (Entity droppedItem : event.getEntities()) {
                            droppedItem.setCreator(player.func_110124_au());
                            mixinWorld.forceSpawnEntity(droppedItem);
                        }
                    }
                }
            }
        });
        IMixinContainer mixinContainer = ContainerUtil.toMixin(player.field_71070_bA);
        mixinContainer.setCaptureInventory(false);
        mixinContainer.getCapturedTransactions().clear();
    };
    public static final PacketFunction HELD_ITEM_CHANGE = (packet, state, player, context) -> {
        CPacketHeldItemChange itemChange = (CPacketHeldItemChange)packet;
        int previousSlot = context.getRequiredExtra("PreviousSlot", Integer.class);
        Container inventoryContainer = player.field_71069_bz;
        InventoryPlayer inventory = player.field_71071_by;
        int preHotbarSize = inventory.field_70462_a.size() - InventoryPlayer.func_70451_h() + inventory.field_70460_b.size() + 4 + 1;
        Slot sourceSlot = inventoryContainer.func_75139_a(previousSlot + preHotbarSize);
        Slot targetSlot = inventoryContainer.func_75139_a(itemChange.func_149614_c() + preHotbarSize);
        ItemStackSnapshot sourceSnapshot = ItemStackUtil.snapshotOf(sourceSlot.func_75211_c());
        ItemStackSnapshot targetSnapshot = ItemStackUtil.snapshotOf(targetSlot.func_75211_c());
        SlotTransaction sourceTransaction = new SlotTransaction(ContainerUtil.getSlotAdapter(inventoryContainer, previousSlot + preHotbarSize), sourceSnapshot, sourceSnapshot);
        SlotTransaction targetTransaction = new SlotTransaction(ContainerUtil.getSlotAdapter(inventoryContainer, itemChange.func_149614_c() + preHotbarSize), targetSnapshot, targetSnapshot);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(player);
            ImmutableList transactions = new ImmutableList.Builder().add((Object)sourceTransaction).add((Object)targetTransaction).build();
            ChangeInventoryEvent.Held changeInventoryEventHeld = SpongeEventFactory.createChangeInventoryEventHeld(Sponge.getCauseStackManager().getCurrentCause(), (Inventory)inventoryContainer, (List)transactions);
            Container openContainer = player.field_71070_bA;
            SpongeImpl.postEvent(changeInventoryEventHeld);
            if (changeInventoryEventHeld.isCancelled() || PacketPhaseUtil.allTransactionsInvalid(changeInventoryEventHeld.getTransactions())) {
                player.field_71135_a.func_147359_a((Packet)new SPacketHeldItemChange(previousSlot));
            } else {
                PacketPhaseUtil.handleSlotRestore(player, openContainer, changeInventoryEventHeld.getTransactions(), false);
                inventory.field_70461_c = itemChange.func_149614_c();
                player.func_143004_u();
            }
        }
    };
    public static final PacketFunction CLOSE_WINDOW = (packet, state, player, context) -> {
        Container container = context.getRequiredExtra("OpenContainer", Container.class);
        ItemStackSnapshot lastCursor = context.getRequiredExtra("Cursor", ItemStackSnapshot.class);
        ItemStackSnapshot newCursor = ItemStackUtil.snapshotOf(player.field_71071_by.func_70445_o());
        try (CauseStackManager.StackFrame frame1 = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(player);
            InteractInventoryEvent.Close event = SpongeCommonEventFactory.callInteractInventoryCloseEvent(container, player, lastCursor, newCursor, true);
            if (event.isCancelled()) {
                return;
            }
        }
        var8_8 = null;
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(player);
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
            context.getCapturedItemsSupplier().ifPresentAndNotEmpty(items -> {
                List entities = items.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
                if (!entities.isEmpty()) {
                    DropItemEvent.Custom drop = SpongeEventFactory.createDropItemEventCustom(Sponge.getCauseStackManager().getCurrentCause(), entities);
                    SpongeImpl.postEvent(drop);
                    if (!drop.isCancelled()) {
                        for (Entity droppedItem : drop.getEntities()) {
                            droppedItem.setCreator(player.func_110124_au());
                            ((IMixinWorldServer)player.func_71121_q()).forceSpawnEntity(droppedItem);
                        }
                    }
                }
            });
            context.getCapturedItemStackSupplier().ifPresentAndNotEmpty(stacks -> {
                List items = stacks.stream().map(drop -> drop.create(player.func_71121_q())).collect(Collectors.toList());
                List entities = items.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
                if (!entities.isEmpty()) {
                    DropItemEvent.Custom drop2 = SpongeEventFactory.createDropItemEventCustom(Sponge.getCauseStackManager().getCurrentCause(), entities);
                    SpongeImpl.postEvent(drop2);
                    if (!drop2.isCancelled()) {
                        for (Entity droppedItem : drop2.getEntities()) {
                            droppedItem.setCreator(player.func_110124_au());
                            ((IMixinWorldServer)player.func_71121_q()).forceSpawnEntity(droppedItem);
                        }
                    }
                }
            });
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        context.getCapturedBlockSupplier().ifPresentAndNotEmpty(blocks -> TrackingUtil.processBlockCaptures(blocks, state, context));
    };
    public static final PacketFunction ENCHANTMENT = (packet, state, player, context) -> {};
    public static final PacketFunction CLIENT_STATUS = (packet, state, player, context) -> {
        if (state == PacketPhase.Inventory.OPEN_INVENTORY) {
            ItemStackSnapshot lastCursor = context.getRequiredExtra("Cursor", ItemStackSnapshot.class);
            ItemStackSnapshot newCursor = ItemStackUtil.snapshotOf(player.field_71071_by.func_70445_o());
            Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(lastCursor, newCursor);
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                Sponge.getCauseStackManager().pushCause(player);
                InteractInventoryEvent.Open event = SpongeEventFactory.createInteractInventoryEventOpen(Sponge.getCauseStackManager().getCurrentCause(), cursorTransaction, ContainerUtil.fromNative(player.field_71070_bA));
                SpongeImpl.postEvent(event);
                if (event.isCancelled()) {
                    player.func_71053_j();
                } else if (!event.getCursorTransaction().isValid()) {
                    PacketPhaseUtil.handleCustomCursor(player, event.getCursorTransaction().getOriginal());
                } else if (event.getCursorTransaction().getCustom().isPresent()) {
                    PacketPhaseUtil.handleCustomCursor(player, event.getCursorTransaction().getFinal());
                }
            }
        }
    };
    public static final PacketFunction RESOURCE_PACKET = (packet, state, player, context) -> {
        ResourcePackStatusEvent.ResourcePackStatus status;
        NetHandlerPlayServer connection = player.field_71135_a;
        IMixinNetHandlerPlayServer mixinHandler = (IMixinNetHandlerPlayServer)connection;
        CPacketResourcePackStatus resource = (CPacketResourcePackStatus)packet;
        ResourcePack pack = ((IMixinPacketResourcePackSend)mixinHandler.getPendingResourcePackQueue().peek()).getResourcePack();
        switch (resource.field_179719_b) {
            case ACCEPTED: {
                status = ResourcePackStatusEvent.ResourcePackStatus.ACCEPTED;
                break;
            }
            case DECLINED: {
                status = ResourcePackStatusEvent.ResourcePackStatus.DECLINED;
                break;
            }
            case SUCCESSFULLY_LOADED: {
                status = ResourcePackStatusEvent.ResourcePackStatus.SUCCESSFULLY_LOADED;
                break;
            }
            case FAILED_DOWNLOAD: {
                status = ResourcePackStatusEvent.ResourcePackStatus.FAILED;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        SpongeImpl.postEvent(SpongeEventFactory.createResourcePackStatusEvent(Sponge.getCauseStackManager().getCurrentCause(), pack, (Player)player, status));
        if (status.wasSuccessful().isPresent()) {
            mixinHandler.getPendingResourcePackQueue().remove();
            if (!mixinHandler.getPendingResourcePackQueue().isEmpty()) {
                while (mixinHandler.getPendingResourcePackQueue().size() > 1) {
                    pack = ((IMixinPacketResourcePackSend)mixinHandler.getPendingResourcePackQueue().remove()).getResourcePack();
                    if (status == ResourcePackStatusEvent.ResourcePackStatus.DECLINED) {
                        SpongeImpl.postEvent(SpongeEventFactory.createResourcePackStatusEvent(Sponge.getCauseStackManager().getCurrentCause(), pack, (Player)player, ResourcePackStatusEvent.ResourcePackStatus.DECLINED));
                        continue;
                    }
                    SpongeImpl.postEvent(SpongeEventFactory.createResourcePackStatusEvent(Sponge.getCauseStackManager().getCurrentCause(), pack, (Player)player, ResourcePackStatusEvent.ResourcePackStatus.ACCEPTED));
                    SpongeImpl.postEvent(SpongeEventFactory.createResourcePackStatusEvent(Sponge.getCauseStackManager().getCurrentCause(), pack, (Player)player, ResourcePackStatusEvent.ResourcePackStatus.SUCCESSFULLY_LOADED));
                }
                if (connection.func_147362_b().func_150724_d()) {
                    connection.func_147359_a((Packet)mixinHandler.getPendingResourcePackQueue().element());
                }
            }
        }
    };
    public static final PacketFunction MOVEMENT = (packet, state, player, context) -> context.getCapturedBlockSupplier().ifPresentAndNotEmpty(blocks -> TrackingUtil.processBlockCaptures(blocks, state, context));
    public static final PacketFunction UNKNOWN_PACKET;
    public static final PacketFunction HANDLED_EXTERNALLY;

    public static void processSpawnedEntities(EntityPlayerMP player, SpawnEntityEvent event) {
        List<Entity> entities = event.getEntities();
        PacketFunction.processEntities(player, entities);
    }

    public static void processEntities(EntityPlayerMP player, Collection<Entity> entities) {
        for (Entity entity : entities) {
            entity.setCreator(player.func_110124_au());
            EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
        }
    }

    public void unwind(Packet<?> var1, IPacketState var2, EntityPlayerMP var3, PhaseContext var4);

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$null$27(ItemStackSnapshot usedSnapshot, EntityPlayerMP player, List entities) {
        projectiles = new ArrayList<Entity>(entities.size());
        spawnEggs = new ArrayList<Entity>(entities.size());
        normalPlacement = new ArrayList<Entity>(entities.size());
        items = new ArrayList<Entity>(entities.size());
        for (Entity entity : entities) {
            if (entity instanceof Projectile || entity instanceof EntityThrowable) {
                projectiles.add(entity);
                continue;
            }
            if (usedSnapshot.getType() == ItemTypes.SPAWN_EGG) {
                spawnEggs.add(entity);
                continue;
            }
            if (entity instanceof EntityItem) {
                items.add(entity);
                continue;
            }
            normalPlacement.add(entity);
        }
        if (!projectiles.isEmpty()) {
            if (ShouldFire.SPAWN_ENTITY_EVENT) {
                frame2 = Sponge.getCauseStackManager().pushCauseFrame();
                var8_8 = null;
                try {
                    Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.PROJECTILE);
                    Sponge.getCauseStackManager().pushCause(usedSnapshot);
                    event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), projectiles);
                    if (SpongeImpl.postEvent(event)) ** GOTO lbl49
                    PacketFunction.processSpawnedEntities(player, event);
                }
                catch (Throwable event) {
                    var8_8 = event;
                    throw event;
                }
                finally {
                    if (frame2 != null) {
                        if (var8_8 != null) {
                            try {
                                frame2.close();
                            }
                            catch (Throwable event) {
                                var8_8.addSuppressed(event);
                            }
                        } else {
                            frame2.close();
                        }
                    }
                }
            } else {
                PacketFunction.processEntities(player, projectiles);
            }
        }
lbl49:
        // 5 sources

        if (!spawnEggs.isEmpty()) {
            if (ShouldFire.SPAWN_ENTITY_EVENT) {
                frame2 = Sponge.getCauseStackManager().pushCauseFrame();
                var8_8 = null;
                try {
                    Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.PROJECTILE);
                    Sponge.getCauseStackManager().pushCause(usedSnapshot);
                    event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), spawnEggs);
                    if (SpongeImpl.postEvent(event)) ** GOTO lbl77
                    PacketFunction.processSpawnedEntities(player, event);
                }
                catch (Throwable var9_13) {
                    var8_8 = var9_13;
                    throw var9_13;
                }
                finally {
                    if (frame2 != null) {
                        if (var8_8 != null) {
                            try {
                                frame2.close();
                            }
                            catch (Throwable var9_12) {
                                var8_8.addSuppressed(var9_12);
                            }
                        } else {
                            frame2.close();
                        }
                    }
                }
            } else {
                PacketFunction.processEntities(player, spawnEggs);
            }
        }
lbl77:
        // 5 sources

        if (!items.isEmpty()) {
            if (ShouldFire.DROP_ITEM_EVENT_DISPENSE) {
                dispense = SpongeEventFactory.createDropItemEventDispense(Sponge.getCauseStackManager().getCurrentCause(), items);
                if (!SpongeImpl.postEvent(dispense)) {
                    PacketFunction.processSpawnedEntities(player, dispense);
                }
            } else {
                PacketFunction.processEntities(player, items);
            }
        }
        if (!normalPlacement.isEmpty()) {
            if (ShouldFire.SPAWN_ENTITY_EVENT) {
                event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), normalPlacement);
                if (!SpongeImpl.postEvent(event)) {
                    PacketFunction.processSpawnedEntities(player, event);
                }
            } else {
                PacketFunction.processEntities(player, normalPlacement);
            }
        }
    }

    static {
        HANDLED_EXTERNALLY = UNKNOWN_PACKET = (packet, state, player, context) -> {
            try (CauseStackManager.StackFrame frame1 = Sponge.getCauseStackManager().pushCauseFrame();){
                Sponge.getCauseStackManager().pushCause(player);
                Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
                context.getCapturedBlockSupplier().ifPresentAndNotEmpty(blocks -> TrackingUtil.processBlockCaptures(blocks, state, context));
                context.getCapturedEntitySupplier().ifPresentAndNotEmpty(entities -> {
                    SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), entities);
                    SpongeImpl.postEvent(event);
                    if (!event.isCancelled()) {
                        PacketFunction.processSpawnedEntities(player, event);
                    }
                });
                context.getCapturedItemsSupplier().ifPresentAndNotEmpty(entities -> {
                    List items = entities.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
                    SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), items);
                    SpongeImpl.postEvent(event);
                    if (!event.isCancelled()) {
                        PacketFunction.processSpawnedEntities(player, event);
                    }
                });
            }
            context.getCapturedEntityDropSupplier().ifPresentAndNotEmpty(map -> {
                PrettyPrinter printer = new PrettyPrinter(80);
                printer.add("Processing Interact At Entity").centre().hr();
                printer.add("The item stacks captured are: ");
                for (Map.Entry entry : map.asMap().entrySet()) {
                    printer.add("  - Entity with UUID: %s", entry.getKey());
                    for (ItemDropData stack : (Collection)entry.getValue()) {
                        printer.add("    - %s", stack);
                    }
                }
                printer.trace(System.err);
            });
            context.getCapturedEntityItemDropSupplier().ifPresentAndNotEmpty(map -> {
                for (Map.Entry entry : map.asMap().entrySet()) {
                    List entities;
                    UUID entityUuid = (UUID)entry.getKey();
                    net.minecraft.entity.Entity entityFromUuid = player.func_71121_q().func_175733_a(entityUuid);
                    Entity affectedEntity = EntityUtil.fromNative(entityFromUuid);
                    if (entityFromUuid == null || (entities = ((Collection)entry.getValue()).stream().map(EntityUtil::fromNative).collect(Collectors.toList())).isEmpty()) continue;
                    CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();
                    Throwable throwable = null;
                    try {
                        Sponge.getCauseStackManager().pushCause(player);
                        Sponge.getCauseStackManager().pushCause(affectedEntity);
                        Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.CUSTOM);
                        DropItemEvent.Custom event = SpongeEventFactory.createDropItemEventCustom(Sponge.getCauseStackManager().getCurrentCause(), entities);
                        SpongeImpl.postEvent(event);
                        if (event.isCancelled()) continue;
                        PacketFunction.processSpawnedEntities(player, event);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (frame == null) continue;
                        if (throwable != null) {
                            try {
                                frame.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        frame.close();
                    }
                }
            });
            context.getCapturedItemStackSupplier().ifPresentAndNotEmpty(drops -> {
                List items = drops.stream().map(drop -> drop.create(player.func_71121_q())).collect(Collectors.toList());
                List entities = items.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
                if (!entities.isEmpty()) {
                    try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                        Sponge.getCauseStackManager().pushCause(player);
                        Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.CUSTOM);
                        DropItemEvent.Custom event = SpongeEventFactory.createDropItemEventCustom(Sponge.getCauseStackManager().getCurrentCause(), entities);
                        SpongeImpl.postEvent(event);
                        if (!event.isCancelled()) {
                            PacketFunction.processSpawnedEntities(player, event);
                        }
                    }
                }
            });
        };
    }
}

