/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerTryUseItem;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.world.IMixinLocation;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.world.BlockChange;

class UseItemPacketState
extends BasicPacketState {
    UseItemPacketState() {
    }

    @Override
    public boolean isInteraction() {
        return true;
    }

    @Override
    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, PhaseContext context) {
        CPacketPlayerTryUseItem placeBlock = (CPacketPlayerTryUseItem)packet;
        net.minecraft.item.ItemStack usedItem = playerMP.func_184586_b(placeBlock.func_187028_a());
        ItemStack itemstack = ItemStackUtil.cloneDefensive(usedItem);
        if (itemstack != null) {
            context.addExtra("ItemUsed", itemstack);
        }
        context.addEntityCaptures().addEntityDropCaptures().addBlockCaptures();
    }

    @Override
    public void handleBlockChangeWithUser(@Nullable BlockChange blockChange, Transaction<BlockSnapshot> transaction, PhaseContext context) {
        Player player = context.getRequiredExtra("PacketPlayer", Player.class);
        BlockPos pos = ((IMixinLocation)((Object)transaction.getFinal().getLocation().get())).getBlockPos();
        IMixinChunk spongeChunk = (IMixinChunk)EntityUtil.getMinecraftWorld(player).func_175726_f(pos);
        if (blockChange == BlockChange.PLACE) {
            spongeChunk.addTrackedBlockPosition((Block)transaction.getFinal().getState().getType(), pos, player, PlayerTracker.Type.OWNER);
        }
        spongeChunk.addTrackedBlockPosition((Block)transaction.getFinal().getState().getType(), pos, player, PlayerTracker.Type.NOTIFIER);
    }
}

