/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import com.flowpowered.math.vector.Vector3d;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.world.IMixinLocation;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;

class BlockEventTickPhaseState
extends TickPhaseState {
    BlockEventTickPhaseState() {
    }

    @Override
    public void associateNeighborBlockNotifier(PhaseContext context, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, WorldServer minecraftWorld, PlayerTracker.Type notifier) {
        User user;
        if (sourcePos == null) {
            LocatableBlock locatableBlock = context.getSource(LocatableBlock.class).orElse(null);
            if (locatableBlock == null) {
                TileEntity tileEntity = context.getSource(TileEntity.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over at a TileEntity!", context));
                locatableBlock = tileEntity.getLocatableBlock();
            }
            sourcePos = ((IMixinLocation)((Object)locatableBlock.getLocation())).getBlockPos();
        }
        if ((user = context.getNotifier().orElse(TrackingUtil.getNotifierOrOwnerFromBlock(minecraftWorld, sourcePos))) != null) {
            IMixinChunk mixinChunk = (IMixinChunk)minecraftWorld.func_175726_f(notifyPos);
            mixinChunk.addTrackedBlockPosition(block, notifyPos, user, PlayerTracker.Type.NOTIFIER);
        }
    }

    @Override
    public boolean spawnEntityOrCapture(PhaseContext context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        Optional<User> notifier = context.getNotifier();
        Optional<User> owner = context.getOwner();
        User entityCreator = notifier.orElseGet(() -> owner.orElse(null));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.CUSTOM);
            ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>(1);
            entities.add(entity);
            SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), entities);
            SpongeImpl.postEvent(spawnEntityEvent);
            if (!spawnEntityEvent.isCancelled()) {
                for (org.spongepowered.api.entity.Entity anEntity : spawnEntityEvent.getEntities()) {
                    if (entityCreator != null) {
                        EntityUtil.toMixin(anEntity).setCreator(entityCreator.getUniqueId());
                    }
                    EntityUtil.getMixinWorld(anEntity).forceSpawnEntity(anEntity);
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public void handleBlockChangeWithUser(@Nullable BlockChange blockChange, Transaction<BlockSnapshot> snapshotTransaction, PhaseContext context) {
        Block block = (Block)snapshotTransaction.getOriginal().getState().getType();
        Location<World> changedLocation = snapshotTransaction.getOriginal().getLocation().get();
        Vector3d changedPosition = changedLocation.getPosition();
        BlockPos changedBlockPos = VecHelper.toBlockPos(changedPosition);
        IMixinChunk changedMixinChunk = (IMixinChunk)((WorldServer)changedLocation.getExtent()).func_175726_f(changedBlockPos);
        User user = TrackingUtil.getNotifierOrOwnerFromBlock(changedLocation);
        if (user != null) {
            changedMixinChunk.addTrackedBlockPosition(block, changedBlockPos, user, PlayerTracker.Type.NOTIFIER);
        }
    }

    @Override
    public void processPostTick(PhaseContext phaseContext) {
        Optional<User> notifier = phaseContext.getNotifier();
        Optional<User> owner = phaseContext.getOwner();
        User entityCreator = notifier.orElseGet(() -> owner.orElse(null));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.CUSTOM);
            phaseContext.getCapturedBlockSupplier().ifPresentAndNotEmpty(blockSnapshots -> TrackingUtil.processBlockCaptures(blockSnapshots, this, phaseContext));
            phaseContext.getCapturedItemsSupplier().ifPresentAndNotEmpty(items -> {
                ArrayList<org.spongepowered.api.entity.Entity> capturedEntities = new ArrayList<org.spongepowered.api.entity.Entity>();
                for (EntityItem entity : items) {
                    capturedEntities.add(EntityUtil.fromNative((Entity)entity));
                }
                SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), capturedEntities);
                SpongeImpl.postEvent(spawnEntityEvent);
                for (org.spongepowered.api.entity.Entity entity : spawnEntityEvent.getEntities()) {
                    if (entityCreator != null) {
                        EntityUtil.toMixin(entity).setCreator(entityCreator.getUniqueId());
                    }
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                }
            });
        }
    }

    public String toString() {
        return "BlockEventTickPhase";
    }
}

