/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.adapter.impl.slots;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import net.minecraft.inventory.IInventory;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.common.interfaces.inventory.IMixinSlot;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.Adapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.impl.MinecraftFabric;
import org.spongepowered.common.item.inventory.lens.impl.slots.FakeSlotLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.slots.SlotLensImpl;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public class SlotAdapter
extends Adapter
implements Slot {
    private final SlotLens<IInventory, net.minecraft.item.ItemStack> slot;
    private final int ordinal;
    private SlotAdapter nextSlot;
    private final ImmutableList<Inventory> slots;
    public int slotNumber = -1;

    public SlotAdapter(net.minecraft.inventory.Slot slot) {
        this(MinecraftFabric.of(slot), SlotAdapter.getLens(slot), slot.field_75224_c instanceof Inventory ? (Inventory)slot.field_75224_c : null);
        this.slotNumber = slot.field_75222_d;
    }

    private static SlotLens<IInventory, net.minecraft.item.ItemStack> getLens(net.minecraft.inventory.Slot slot) {
        if (((IMixinSlot)slot).getSlotIndex() >= 0) {
            if (slot.field_75224_c instanceof InventoryAdapter) {
                return ((InventoryAdapter)slot.field_75224_c).getSlotProvider().getSlot(((IMixinSlot)slot).getSlotIndex());
            }
            return new SlotLensImpl(((IMixinSlot)slot).getSlotIndex());
        }
        return new FakeSlotLensImpl(slot);
    }

    public SlotAdapter(Fabric<IInventory> inventory, SlotLens<IInventory, net.minecraft.item.ItemStack> lens, Inventory parent) {
        super(inventory, lens, parent);
        this.slot = lens;
        this.ordinal = lens.getOrdinal(inventory);
        this.slots = ImmutableList.of((Object)this);
        this.slotNumber = this.ordinal;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public int getStackSize() {
        return this.slot.getStack(this.inventory).func_190916_E();
    }

    @Override
    public <T extends Inventory> Iterable<T> slots() {
        return this.slots;
    }

    @Override
    public <T extends Inventory> T first() {
        return (T)this;
    }

    @Override
    public Optional<ItemStack> poll() {
        net.minecraft.item.ItemStack stack = this.inventory.getStack(this.ordinal);
        if (stack.func_190926_b()) {
            return Optional.empty();
        }
        this.inventory.setStack(this.ordinal, net.minecraft.item.ItemStack.field_190927_a);
        return Optional.of(ItemStackUtil.fromNative(stack));
    }

    @Override
    public Optional<ItemStack> poll(int limit) {
        return super.poll(limit);
    }

    @Override
    public Optional<ItemStack> peek() {
        net.minecraft.item.ItemStack stack = this.slot.getStack(this.inventory);
        if (stack.func_190926_b()) {
            return Optional.empty();
        }
        return ItemStackUtil.cloneDefensiveOptional(stack);
    }

    @Override
    public Optional<ItemStack> peek(int limit) {
        return super.peek(limit);
    }

    @Override
    public InventoryTransactionResult offer(ItemStack stack) {
        InventoryTransactionResult.Builder result = InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.SUCCESS);
        net.minecraft.item.ItemStack nativeStack = ItemStackUtil.toNative(stack);
        int maxStackSize = this.slot.getMaxStackSize(this.inventory);
        int remaining = stack.getQuantity();
        net.minecraft.item.ItemStack old = this.slot.getStack(this.inventory);
        int push = Math.min(remaining, maxStackSize);
        if (old.func_190926_b() && this.slot.setStack(this.inventory, ItemStackUtil.cloneDefensiveNative(nativeStack, push))) {
            remaining -= push;
        } else if (!old.func_190926_b() && ItemStackUtil.compareIgnoreQuantity(old, stack)) {
            this.inventory.markDirty();
            push = Math.max(Math.min(maxStackSize - old.func_190916_E(), remaining), 0);
            old.func_190920_e(old.func_190916_E() + push);
            remaining -= push;
        }
        if (remaining == stack.getQuantity()) {
            result.reject(ItemStackUtil.cloneDefensive(nativeStack));
        } else {
            stack.setQuantity(remaining);
        }
        return result.build();
    }

    @Override
    public InventoryTransactionResult set(ItemStack stack) {
        InventoryTransactionResult.Builder result = InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.SUCCESS);
        net.minecraft.item.ItemStack nativeStack = ItemStackUtil.toNative(stack);
        net.minecraft.item.ItemStack old = this.slot.getStack(this.inventory);
        if (stack.getType() == ItemTypes.NONE) {
            this.clear();
            return result.replace(ItemStackUtil.fromNative(old)).build();
        }
        int remaining = stack.getQuantity();
        int push = Math.min(remaining, this.slot.getMaxStackSize(this.inventory));
        if (this.slot.setStack(this.inventory, ItemStackUtil.cloneDefensiveNative(nativeStack, push))) {
            result.replace(ItemStackUtil.fromNative(old));
            remaining -= push;
        }
        if (remaining > 0) {
            result.reject(ItemStackUtil.cloneDefensive(nativeStack, remaining));
        }
        return result.build();
    }

    @Override
    public void clear() {
        this.slot.setStack(this.inventory, net.minecraft.item.ItemStack.field_190927_a);
    }

    @Override
    public int size() {
        return !this.slot.getStack(this.inventory).func_190926_b() ? 1 : 0;
    }

    @Override
    public int totalItems() {
        return this.slot.getStack(this.inventory).func_190916_E();
    }

    @Override
    public int capacity() {
        return 1;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public boolean contains(ItemStack stack) {
        net.minecraft.item.ItemStack slotStack = this.slot.getStack(this.inventory);
        return slotStack.func_190926_b() ? ItemStackUtil.toNative(stack).func_190926_b() : ItemStackUtil.compareIgnoreQuantity(slotStack, stack) && slotStack.func_190916_E() >= stack.getQuantity();
    }

    @Override
    public boolean containsAny(ItemStack stack) {
        net.minecraft.item.ItemStack slotStack = this.slot.getStack(this.inventory);
        return slotStack.func_190926_b() ? ItemStackUtil.toNative(stack).func_190926_b() : ItemStackUtil.compareIgnoreQuantity(slotStack, stack);
    }

    @Override
    public boolean contains(ItemType type) {
        net.minecraft.item.ItemStack slotStack = this.slot.getStack(this.inventory);
        return slotStack.func_190926_b() ? type == null || type == ItemTypes.AIR : slotStack.func_77973_b().equals(type);
    }

    @Override
    public int getMaxStackSize() {
        return super.getMaxStackSize();
    }
}

