/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.custom;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IInteractionObject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.item.inventory.InteractInventoryEvent;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.property.AbstractInventoryProperty;
import org.spongepowered.api.item.inventory.property.GuiId;
import org.spongepowered.api.item.inventory.property.GuiIdProperty;
import org.spongepowered.api.item.inventory.property.GuiIds;
import org.spongepowered.api.item.inventory.property.InventoryCapacity;
import org.spongepowered.api.item.inventory.property.InventoryDimension;
import org.spongepowered.api.item.inventory.property.InventoryTitle;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TranslatableText;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.common.data.type.SpongeGuiId;
import org.spongepowered.common.item.inventory.archetype.CompositeInventoryArchetype;
import org.spongepowered.common.item.inventory.custom.CustomContainer;
import org.spongepowered.common.item.inventory.custom.CustomInventoryListener;

public class CustomInventory
implements IInventory,
IInteractionObject {
    public static final String INVENTORY_CAPACITY = InventoryCapacity.class.getSimpleName().toLowerCase(Locale.ENGLISH);
    public static final String INVENTORY_DIMENSION = InventoryDimension.class.getSimpleName().toLowerCase(Locale.ENGLISH);
    public static final String TITLE = InventoryTitle.class.getSimpleName().toLowerCase(Locale.ENGLISH);
    private InventoryBasic inv;
    protected InventoryArchetype archetype;
    private Map<String, InventoryProperty<?, ?>> properties;
    private Carrier carrier;
    private Set<EntityPlayer> viewers = new HashSet<EntityPlayer>();

    public CustomInventory(InventoryArchetype archetype, Map<String, InventoryProperty<?, ?>> properties, Carrier carrier, Map<Class<? extends InteractInventoryEvent>, List<Consumer<? extends InteractInventoryEvent>>> listeners, PluginContainer plugin) {
        boolean isCustom;
        this.archetype = archetype;
        this.properties = properties;
        this.carrier = carrier;
        InventoryDimension size = (InventoryDimension)properties.get(INVENTORY_DIMENSION);
        int count = size != null ? size.getColumns() * size.getRows() : CustomInventory.getSlotCount(archetype);
        InventoryTitle titleProperty = properties.getOrDefault(TITLE, archetype.getProperty(TITLE).orElse(null));
        boolean bl = isCustom = titleProperty == null || !(titleProperty.getValue() instanceof TranslatableText);
        String title = titleProperty == null ? "" : (isCustom ? TextSerializers.LEGACY_FORMATTING_CODE.serialize((Text)titleProperty.getValue()) : ((TranslatableText)titleProperty.getValue()).getTranslation().getId());
        this.inv = new InventoryBasic(title, isCustom, count);
        this.inv.func_110134_a(i -> this.viewers.forEach(v -> v.field_71070_bA.func_75142_b()));
        for (Map.Entry<Class<? extends InteractInventoryEvent>, List<Consumer<? extends InteractInventoryEvent>>> entry : listeners.entrySet()) {
            Sponge.getEventManager().registerListener(plugin, entry.getKey(), new CustomInventoryListener((Inventory)((Object)this), entry.getValue()));
        }
    }

    private static int getSlotCount(InventoryArchetype archetype) {
        Optional<InventoryDimension> dimension = archetype.getProperty(InventoryDimension.class, INVENTORY_DIMENSION);
        if (dimension.isPresent()) {
            return dimension.get().getColumns() * dimension.get().getRows();
        }
        Optional<InventoryCapacity> capacity = archetype.getProperty(InventoryCapacity.class, INVENTORY_CAPACITY);
        if (capacity.isPresent()) {
            return (Integer)capacity.get().getValue();
        }
        int count = 0;
        List<InventoryArchetype> childs = archetype.getChildArchetypes();
        if (childs.isEmpty()) {
            throw new IllegalArgumentException("Missing dimensions!");
        }
        for (InventoryArchetype childArchetype : childs) {
            count += CustomInventory.getSlotCount(childArchetype);
        }
        return count;
    }

    public InventoryArchetype getArchetype() {
        return this.archetype;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        CompositeInventoryArchetype.ContainerProvider provider;
        this.viewers.add(playerIn);
        if (this.archetype instanceof CompositeInventoryArchetype && (provider = ((CompositeInventoryArchetype)this.archetype).getContainerProvider()) != null) {
            return provider.provide(this, playerIn);
        }
        return new CustomContainer(playerIn, this);
    }

    public String func_174875_k() {
        String key = AbstractInventoryProperty.getDefaultKey(GuiIdProperty.class).toString();
        InventoryProperty<?, ?> property = this.properties.get(key);
        if (property instanceof GuiIdProperty) {
            if (property.getValue() instanceof SpongeGuiId) {
                return ((SpongeGuiId)property.getValue()).getInternalId();
            }
            return ((GuiId)((GuiIdProperty)property).getValue()).getId();
        }
        GuiId guiId = this.archetype.getProperty(GuiIdProperty.class, key).map(AbstractInventoryProperty::getValue).orElse(GuiIds.CHEST);
        if (guiId instanceof SpongeGuiId) {
            return ((SpongeGuiId)guiId).getInternalId();
        }
        return guiId.getId();
    }

    public ITextComponent func_145748_c_() {
        return this.inv.func_145748_c_();
    }

    public String func_70005_c_() {
        return this.inv.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inv.func_145818_k_();
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public boolean func_191420_l() {
        return this.inv.func_191420_l();
    }

    public ItemStack func_70301_a(int index) {
        return this.inv.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.inv.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.inv.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inv.func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public void func_70296_d() {
        this.inv.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inv.func_70300_a(player);
    }

    public void func_174889_b(EntityPlayer player) {
        this.viewers.add(player);
        this.inv.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.viewers.remove(player);
        this.inv.func_174886_c(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.inv.func_94041_b(index, stack);
    }

    public int func_174887_a_(int id) {
        return this.inv.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.inv.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.inv.func_174890_g();
    }

    public void func_174888_l() {
        this.inv.func_174888_l();
    }

    public Map<String, InventoryProperty<?, ?>> getProperties() {
        return this.properties;
    }

    public Carrier getCarrier() {
        return this.carrier;
    }
}

