/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.comp;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.comp.CraftingInventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.comp.GridInventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.comp.CraftingGridInventoryLens;
import org.spongepowered.common.item.inventory.lens.comp.CraftingInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.comp.CraftingGridInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.GridInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.slots.CraftingOutputSlotLens;

public class CraftingInventoryLensImpl
extends GridInventoryLensImpl
implements CraftingInventoryLens<IInventory, ItemStack> {
    private final int outputSlotIndex;
    private final CraftingOutputSlotLens<IInventory, ItemStack> outputSlot;
    private final CraftingGridInventoryLens<IInventory, ItemStack> craftingGrid;

    public CraftingInventoryLensImpl(int outputSlotIndex, int gridBase, int width, int height, SlotProvider<IInventory, ItemStack> slots) {
        this(outputSlotIndex, gridBase, width, height, width, GridInventoryAdapter.class, slots);
    }

    public CraftingInventoryLensImpl(int outputSlotIndex, int gridBase, int width, int height, Class<? extends Inventory> adapterType, SlotProvider<IInventory, ItemStack> slots) {
        this(outputSlotIndex, gridBase, width, height, width, adapterType, slots);
    }

    public CraftingInventoryLensImpl(int outputSlotIndex, int gridBase, int width, int height, int rowStride, SlotProvider<IInventory, ItemStack> slots) {
        this(outputSlotIndex, gridBase, width, height, rowStride, 0, 0, GridInventoryAdapter.class, slots);
    }

    public CraftingInventoryLensImpl(int outputSlotIndex, int gridBase, int width, int height, int rowStride, Class<? extends Inventory> adapterType, SlotProvider<IInventory, ItemStack> slots) {
        this(outputSlotIndex, gridBase, width, height, rowStride, 0, 0, adapterType, slots);
    }

    public CraftingInventoryLensImpl(int outputSlotIndex, int gridBase, int width, int height, int rowStride, int xBase, int yBase, SlotProvider<IInventory, ItemStack> slots) {
        this(outputSlotIndex, gridBase, width, height, rowStride, xBase, yBase, GridInventoryAdapter.class, slots);
    }

    public CraftingInventoryLensImpl(int outputSlotIndex, int gridBase, int width, int height, int rowStride, int xBase, int yBase, Class<? extends Inventory> adapterType, SlotProvider<IInventory, ItemStack> slots) {
        super(gridBase, width, height, rowStride, xBase, yBase, adapterType, slots);
        this.outputSlotIndex = outputSlotIndex;
        this.outputSlot = (CraftingOutputSlotLens)slots.getSlot(this.outputSlotIndex);
        this.craftingGrid = new CraftingGridInventoryLensImpl(this.base, this.width, this.height, this.width, slots);
        ++this.size;
        this.initOther(slots);
    }

    private void initOther(SlotProvider<IInventory, ItemStack> slots) {
        this.addSpanningChild(this.outputSlot, new InventoryProperty[0]);
    }

    @Override
    public CraftingGridInventoryLens<IInventory, ItemStack> getCraftingGrid() {
        return this.craftingGrid;
    }

    @Override
    public CraftingOutputSlotLens<IInventory, ItemStack> getOutputSlot() {
        return this.outputSlot;
    }

    @Override
    public ItemStack getOutputStack(Fabric<IInventory> inv) {
        return (ItemStack)this.outputSlot.getStack(inv);
    }

    @Override
    public boolean setOutputStack(Fabric<IInventory> inv, ItemStack stack) {
        return this.outputSlot.setStack(inv, stack);
    }

    @Override
    public int getRealIndex(Fabric<IInventory> inv, int ordinal) {
        if (!this.checkOrdinal(ordinal)) {
            return -1;
        }
        if (ordinal < this.size - 1) {
            return super.getRealIndex(inv, ordinal);
        }
        return this.outputSlotIndex;
    }

    @Override
    public InventoryAdapter<IInventory, ItemStack> getAdapter(Fabric<IInventory> inv, Inventory parent) {
        return new CraftingInventoryAdapter(inv, this, parent);
    }
}

