/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.comp;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.comp.GridInventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.comp.GridInventoryLens;
import org.spongepowered.common.item.inventory.lens.comp.InventoryColumnLens;
import org.spongepowered.common.item.inventory.lens.comp.InventoryRowLens;
import org.spongepowered.common.item.inventory.lens.impl.comp.Inventory2DLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.InventoryColumnLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.InventoryRowLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.struct.LensHandle;

public class GridInventoryLensImpl
extends Inventory2DLensImpl
implements GridInventoryLens<IInventory, ItemStack> {
    protected List<LensHandle<IInventory, ItemStack>> rows;
    protected List<LensHandle<IInventory, ItemStack>> cols;

    public GridInventoryLensImpl(int base, int width, int height, SlotProvider<IInventory, ItemStack> slots) {
        this(base, width, height, 1, GridInventoryAdapter.class, slots);
    }

    public GridInventoryLensImpl(int base, int width, int height, Class<? extends Inventory> adapterType, SlotProvider<IInventory, ItemStack> slots) {
        this(base, width, height, width, adapterType, slots);
    }

    public GridInventoryLensImpl(int base, int width, int height, int rowStride, SlotProvider<IInventory, ItemStack> slots) {
        this(base, width, height, rowStride, 0, 0, GridInventoryAdapter.class, slots);
    }

    public GridInventoryLensImpl(int base, int width, int height, int rowStride, Class<? extends Inventory> adapterType, SlotProvider<IInventory, ItemStack> slots) {
        this(base, width, height, rowStride, 0, 0, adapterType, slots);
    }

    public GridInventoryLensImpl(int base, int width, int height, int rowStride, int xBase, int yBase, SlotProvider<IInventory, ItemStack> slots) {
        this(base, width, height, rowStride, xBase, yBase, GridInventoryAdapter.class, slots);
    }

    public GridInventoryLensImpl(int base, int width, int height, int rowStride, int xBase, int yBase, Class<? extends Inventory> adapterType, SlotProvider<IInventory, ItemStack> slots) {
        super(base, width, height, rowStride, xBase, yBase, adapterType, slots);
    }

    @Override
    protected void init(SlotProvider<IInventory, ItemStack> slots) {
        super.init(slots, false);
        this.rows = new ArrayList<LensHandle<IInventory, ItemStack>>();
        this.cols = new ArrayList<LensHandle<IInventory, ItemStack>>();
        int y = 0;
        int base = this.base;
        while (y < this.height) {
            InventoryRowLensImpl row = new InventoryRowLensImpl(base, this.width, this.xBase, this.yBase + y, slots);
            this.addRow(row);
            ++y;
            base += this.stride;
        }
        int x = 0;
        base = this.base;
        while (x < this.width) {
            InventoryColumnLensImpl column = new InventoryColumnLensImpl(base, this.height, this.stride, this.xBase + x, this.yBase, slots);
            this.addColumn(column);
            ++x;
            ++base;
        }
        this.cache();
    }

    protected void addRow(InventoryRowLens<IInventory, ItemStack> row) {
        super.addSpanningChild(row, new InventoryProperty[0]);
        this.rows.add(new LensHandle<IInventory, ItemStack>(row, new InventoryProperty[0]));
    }

    protected void addColumn(InventoryColumnLens<IInventory, ItemStack> column) {
        super.addChild(column, new InventoryProperty[0]);
        this.cols.add(new LensHandle<IInventory, ItemStack>(column, new InventoryProperty[0]));
    }

    @Override
    public InventoryRowLens<IInventory, ItemStack> getRow(int row) {
        return (InventoryRowLens)this.rows.get((int)row).lens;
    }

    @Override
    public InventoryColumnLens<IInventory, ItemStack> getColumn(int column) {
        return (InventoryColumnLens)this.cols.get((int)column).lens;
    }

    @Override
    public int getRealIndex(Fabric<IInventory> inv, int ordinal) {
        LensHandle child = this.getLensForOrdinal(ordinal);
        return child.lens.getRealIndex(inv, ordinal - child.ordinal);
    }

    @Override
    public InventoryAdapter<IInventory, ItemStack> getAdapter(Fabric<IInventory> inv, Inventory parent) {
        return new GridInventoryAdapter(inv, this, parent);
    }
}

