/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.slots;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.InvalidOrdinalException;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.MinecraftLens;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;
import org.spongepowered.common.text.translation.SpongeTranslation;

public class SlotLensImpl
extends MinecraftLens
implements SlotLens<IInventory, ItemStack> {
    public static final Translation SLOT_NAME = new SpongeTranslation("slot.name");
    protected int maxStackSize = -1;

    public SlotLensImpl(int index) {
        this(index, SlotAdapter.class);
    }

    public SlotLensImpl(int index, Class<? extends Inventory> adapterType) {
        super(index, 1, adapterType, (SlotProvider<IInventory, ItemStack>)null);
        this.availableSlots.add(this.getOrdinal((Fabric<IInventory>)null));
    }

    @Override
    protected final void init(SlotProvider<IInventory, ItemStack> slots) {
    }

    @Override
    public Translation getName(Fabric<IInventory> inv) {
        return SLOT_NAME;
    }

    @Override
    public InventoryAdapter<IInventory, ItemStack> getAdapter(Fabric<IInventory> inv, Inventory parent) {
        return new SlotAdapter(inv, this, parent);
    }

    @Override
    public List<Lens<IInventory, ItemStack>> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public List<Lens<IInventory, ItemStack>> getSpanningChildren() {
        return Collections.emptyList();
    }

    @Override
    public int getOrdinal(Fabric<IInventory> inv) {
        return this.base;
    }

    @Override
    public int getRealIndex(Fabric<IInventory> inv, int ordinal) {
        return ordinal != 0 ? -1 : this.getOrdinal(inv);
    }

    @Override
    public ItemStack getStack(Fabric<IInventory> inv, int ordinal) {
        if (ordinal != 0) {
            throw new InvalidOrdinalException("Non-zero slot ordinal");
        }
        return this.getStack(inv);
    }

    @Override
    public ItemStack getStack(Fabric<IInventory> inv) {
        return ((Fabric)Preconditions.checkNotNull(inv, (Object)"Target inventory")).getStack(this.base);
    }

    @Override
    public boolean setStack(Fabric<IInventory> inv, int ordinal, ItemStack stack) {
        if (ordinal != 0) {
            throw new InvalidOrdinalException("Non-zero slot ordinal");
        }
        return this.setStack(inv, stack);
    }

    @Override
    public boolean setStack(Fabric<IInventory> inv, ItemStack stack) {
        ((Fabric)Preconditions.checkNotNull(inv, (Object)"Target inventory")).setStack(this.base, stack);
        return true;
    }

    @Override
    public Lens<IInventory, ItemStack> getLens(int index) {
        return this;
    }

    @Override
    public Collection<InventoryProperty<?, ?>> getProperties(int index) {
        return Collections.emptyList();
    }

    @Override
    public boolean has(Lens<IInventory, ItemStack> lens) {
        return false;
    }

    @Override
    public boolean isSubsetOf(Collection<Lens<IInventory, ItemStack>> c) {
        return false;
    }
}

