/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.launch.transformer.tracker;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.ClassWriter;
import org.spongepowered.asm.lib.Label;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.common.launch.transformer.tracker.MethodEntry;
import org.spongepowered.common.launch.transformer.tracker.TrackedType;
import org.spongepowered.common.launch.transformer.tracker.TrackerRegistry;

public class TrackerClassTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null || TrackerRegistry.trackerClasses.contains(name)) {
            return basicClass;
        }
        ClassReader classReader = new ClassReader(basicClass);
        ClassWriter classWriter = new ClassWriter(classReader, 0);
        TrackerClassVisitor classVisitor = new TrackerClassVisitor(classWriter);
        classReader.accept(classVisitor, 0);
        return classWriter.toByteArray();
    }

    private static class TrackerMethodVisitor
    extends MethodVisitor {
        private final TrackerClassVisitor classVisitor;

        TrackerMethodVisitor(MethodVisitor mv, TrackerClassVisitor classVisitor) {
            super(327680, mv);
            this.classVisitor = classVisitor;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            MethodEntry entry;
            if (opcode != 182 && opcode != 185 || (entry = TrackerRegistry.methodLists.get(owner + ';' + name + ';' + desc)) == null) {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
                return;
            }
            for (Map.Entry<TrackedType, MethodEntry.TargetTracker> entry1 : entry.entries.entrySet()) {
                if (!entry1.getKey().knownSubtypes.contains(owner)) continue;
                MethodEntry.TargetTracker target = entry1.getValue();
                super.visitMethodInsn(184, target.type, name, target.desc, false);
                return;
            }
            String simpleOwner = owner;
            int index = simpleOwner.lastIndexOf(47);
            if (index != -1) {
                simpleOwner = simpleOwner.substring(index + 1);
            }
            String methodName = "redirect" + simpleOwner + '$' + name;
            String methodId = methodName + ';' + desc;
            String methodDesc = "(Ljava/lang/Object;" + desc.substring(1);
            if (!this.classVisitor.addedMethods.containsKey(methodId)) {
                TrackerMethodEntry methodEntry = new TrackerMethodEntry();
                methodEntry.entry = entry;
                methodEntry.oOpcode = opcode;
                methodEntry.oName = name;
                methodEntry.oDesc = desc;
                methodEntry.oOwner = owner;
                methodEntry.oItf = itf;
                methodEntry.nName = methodName;
                methodEntry.nDesc = methodDesc;
                this.classVisitor.addedMethods.put(methodId, methodEntry);
            }
            super.visitMethodInsn(184, this.classVisitor.name, methodName, methodDesc, false);
        }
    }

    private static class TrackerMethodEntry {
        private MethodEntry entry;
        private String oOwner;
        private String oName;
        private String oDesc;
        private int oOpcode;
        private boolean oItf;
        private String nName;
        private String nDesc;

        private TrackerMethodEntry() {
        }
    }

    private static class TrackerClassVisitor
    extends ClassVisitor {
        private final Map<String, TrackerMethodEntry> addedMethods = new HashMap<String, TrackerMethodEntry>();
        private String name;

        TrackerClassVisitor(ClassVisitor cv) {
            super(327680, cv);
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.name = name;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new TrackerMethodVisitor(super.visitMethod(access, name, desc, signature, exceptions), this);
        }

        @Override
        public void visitEnd() {
            for (TrackerMethodEntry e : this.addedMethods.values()) {
                MethodVisitor m = super.visitMethod(10, e.nName, e.nDesc, null, null);
                m.visitCode();
                Set<Map.Entry<TrackedType, MethodEntry.TargetTracker>> set = ((TrackerMethodEntry)e).entry.entries.entrySet();
                for (Map.Entry<TrackedType, MethodEntry.TargetTracker> entry1 : set) {
                    MethodEntry.TargetTracker target = entry1.getValue();
                    String targetName = entry1.getKey().name;
                    m.visitVarInsn(25, 0);
                    m.visitTypeInsn(193, targetName);
                    Label ifLabel = new Label();
                    m.visitJumpInsn(153, ifLabel);
                    m.visitVarInsn(25, 0);
                    m.visitTypeInsn(192, targetName);
                    for (int i = 0; i < ((TrackerMethodEntry)e).entry.paramTypes.length; ++i) {
                        m.visitVarInsn(((TrackerMethodEntry)e).entry.paramTypes[i].getOpcode(21), i + 1);
                    }
                    m.visitMethodInsn(184, target.type, e.oName, target.desc, false);
                    m.visitInsn(((TrackerMethodEntry)e).entry.returnType.getOpcode(172));
                    m.visitLabel(ifLabel);
                    m.visitFrame(3, 0, null, 0, null);
                }
                m.visitVarInsn(25, 0);
                m.visitTypeInsn(192, e.oOwner);
                for (int i = 0; i < ((TrackerMethodEntry)e).entry.paramTypes.length; ++i) {
                    m.visitVarInsn(((TrackerMethodEntry)e).entry.paramTypes[i].getOpcode(21), i + 1);
                }
                m.visitMethodInsn(e.oOpcode, e.oOwner, e.oName, e.oDesc, e.oItf);
                m.visitInsn(((TrackerMethodEntry)e).entry.returnType.getOpcode(172));
                int locals = ((TrackerMethodEntry)e).entry.paramTypes.length + 1;
                m.visitMaxs(locals, locals);
                m.visitEnd();
            }
            super.visitEnd();
        }
    }
}

