/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.boss;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.monster.Wither;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.interfaces.entity.IMixinGriefer;
import org.spongepowered.common.interfaces.entity.explosive.IMixinFusedExplosive;
import org.spongepowered.common.mixin.core.entity.monster.MixinEntityMob;

@Mixin(value={EntityWither.class})
public abstract class MixinEntityWither
extends MixinEntityMob
implements Wither,
IMixinFusedExplosive {
    private static final String TARGET_NEW_EXPLOSION = "Lnet/minecraft/world/World;newExplosion(Lnet/minecraft/entity/Entity;DDDFZZ)Lnet/minecraft/world/Explosion;";
    private static final int DEFAULT_EXPLOSION_RADIUS = 7;
    private int explosionRadius = 7;
    private int fuseDuration = 220;

    @Shadow
    public abstract int func_82203_t(int var1);

    @Shadow
    public abstract void func_82211_c(int var1, int var2);

    @Shadow
    public abstract void func_82215_s(int var1);

    @Shadow
    public abstract int func_82212_n();

    @Override
    public List<Living> getTargets() {
        ArrayList<Living> values = new ArrayList<Living>();
        for (int i = 0; i < 2; ++i) {
            int id = this.func_82203_t(i);
            if (id <= 0) continue;
            values.add((Living)this.field_70170_p.func_73045_a(id));
        }
        return values;
    }

    @Override
    public void setTargets(List<Living> targets) {
        Preconditions.checkNotNull(targets, (Object)"Targets are null!");
        for (int i = 0; i < 2; ++i) {
            this.func_82211_c(i, targets.size() > i ? ((EntityLivingBase)targets.get(i)).func_145782_y() : 0);
        }
    }

    @Redirect(method={"updateAITasks"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/GameRules;getBoolean(Ljava/lang/String;)Z"))
    private boolean onCanGrief(GameRules gameRules, String rule) {
        return gameRules.func_82766_b(rule) && ((IMixinGriefer)((Object)this)).canGrief();
    }

    @ModifyArg(method={"launchWitherSkullToCoords"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnEntity(Lnet/minecraft/entity/Entity;)Z"))
    protected Entity onSpawnWitherSkull(Entity entity) {
        ((IMixinGriefer)entity).setCanGrief(((IMixinGriefer)((Object)this)).canGrief());
        return entity;
    }

    @Override
    public Optional<Integer> getExplosionRadius() {
        return Optional.of(this.explosionRadius);
    }

    @Override
    public void setExplosionRadius(Optional<Integer> radius) {
        this.explosionRadius = radius.orElse(7);
    }

    @Override
    public int getFuseDuration() {
        return this.fuseDuration;
    }

    @Override
    public void setFuseDuration(int fuseTicks) {
        this.fuseDuration = fuseTicks;
    }

    @Override
    public int getFuseTicksRemaining() {
        return this.func_82212_n();
    }

    @Override
    public void setFuseTicksRemaining(int fuseTicks) {
        this.func_82215_s(fuseTicks);
    }

    @Override
    public void detonate() {
        this.setFuseTicksRemaining(1);
    }

    @Override
    public void prime() {
        Preconditions.checkState((!this.isPrimed() ? 1 : 0) != 0, (Object)"already primed");
        if (this.shouldPrime()) {
            this.setFuseTicksRemaining(this.fuseDuration);
            this.postPrime();
        }
    }

    @Override
    public void defuse() {
        Preconditions.checkState((boolean)this.isPrimed(), (Object)"not primed");
        if (this.shouldDefuse()) {
            this.func_82215_s(0);
            this.postDefuse();
        }
    }

    @Override
    public boolean isPrimed() {
        return this.getFuseTicksRemaining() > 0;
    }

    @Redirect(method={"ignite"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/boss/EntityWither;setInvulTime(I)V"))
    protected void onSpawnPrime(EntityWither self, int fuseTicks) {
        this.prime();
    }

    @Redirect(method={"updateAITasks"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;newExplosion(Lnet/minecraft/entity/Entity;DDDFZZ)Lnet/minecraft/world/Explosion;"))
    protected net.minecraft.world.Explosion onExplode(World worldObj, Entity self, double x, double y, double z, float strength, boolean flaming, boolean smoking) {
        return this.detonate(Explosion.builder().sourceExplosive(this).location(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)worldObj, new Vector3d(x, y, z))).radius(this.explosionRadius).canCauseFire(flaming).shouldPlaySmoke(smoking).shouldBreakBlocks(smoking && ((IMixinGriefer)((Object)this)).canGrief())).orElse(null);
    }
}

