/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.player;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketHeldItemChange;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.entity.MainPlayerInventory;
import org.spongepowered.api.item.inventory.entity.PlayerInventory;
import org.spongepowered.api.item.inventory.equipment.EquipmentInventory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.interfaces.entity.player.IMixinInventoryPlayer;
import org.spongepowered.common.item.inventory.adapter.impl.comp.EquipmentInventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.comp.HotbarAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.comp.MainPlayerInventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.slots.EquipmentSlotAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.MinecraftLens;
import org.spongepowered.common.item.inventory.lens.impl.collections.SlotCollection;
import org.spongepowered.common.item.inventory.lens.impl.comp.OrderedInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.fabric.DefaultInventoryFabric;
import org.spongepowered.common.item.inventory.lens.impl.minecraft.PlayerInventoryLens;
import org.spongepowered.common.item.inventory.observer.InventoryEventArgs;

@Mixin(value={InventoryPlayer.class})
public abstract class MixinInventoryPlayer
implements IMixinInventoryPlayer,
PlayerInventory {
    @Shadow
    public int field_70461_c;
    @Shadow
    public EntityPlayer field_70458_d;
    @Shadow
    @Final
    public NonNullList<ItemStack> field_70462_a;
    @Shadow
    @Final
    public NonNullList<ItemStack> field_70460_b;
    @Shadow
    @Final
    public NonNullList<ItemStack> field_184439_c;
    @Shadow
    @Final
    private List<NonNullList<ItemStack>> field_184440_g;
    protected SlotCollection slots;
    protected Fabric<IInventory> inventory;
    protected MinecraftLens lens;
    private Player carrier;
    private HotbarAdapter hotbar;
    private MainPlayerInventoryAdapter main;
    private EquipmentInventoryAdapter equipment;
    private SlotAdapter offhand;
    private int offhandIndex;

    @Shadow
    public abstract int func_70297_j_();

    @Shadow
    public abstract int func_70302_i_();

    @Inject(method={"<init>*"}, at={@At(value="RETURN")}, remap=false)
    private void onConstructed(EntityPlayer playerIn, CallbackInfo ci) {
        for (NonNullList<ItemStack> inventory : this.field_184440_g) {
            if (inventory == this.field_184439_c) break;
            this.offhandIndex += inventory.size();
        }
        if (playerIn instanceof EntityPlayerMP) {
            this.carrier = (Player)playerIn;
            this.inventory = new DefaultInventoryFabric((IInventory)this);
            Class<?> clazz = this.getClass();
            if (clazz == InventoryPlayer.class) {
                this.slots = new SlotCollection.Builder().add(this.field_70462_a.size()).add(this.field_184439_c.size()).add(this.field_70460_b.size(), EquipmentSlotAdapter.class).add(this.func_70302_i_() - this.field_70462_a.size() - this.field_184439_c.size() - this.field_70460_b.size()).build();
                this.lens = new PlayerInventoryLens(this, this.slots);
            } else if (this.func_70302_i_() != 0) {
                this.slots = new SlotCollection.Builder().add(this.func_70302_i_()).build();
                this.lens = new OrderedInventoryLensImpl(0, this.func_70302_i_(), 1, (SlotProvider<IInventory, ItemStack>)this.slots);
            }
        }
    }

    @Override
    public int getHeldItemIndex(EnumHand hand) {
        switch (hand) {
            case MAIN_HAND: {
                return this.field_70461_c;
            }
            case OFF_HAND: {
                return this.offhandIndex;
            }
        }
        throw new AssertionError(hand);
    }

    @Override
    public Lens<IInventory, ItemStack> getRootLens() {
        return this.lens;
    }

    @Override
    public Fabric<IInventory> getInventory() {
        return this.inventory;
    }

    @Override
    public Inventory getChild(Lens<IInventory, ItemStack> lens) {
        return null;
    }

    @Override
    public Optional<Player> getCarrier() {
        return Optional.ofNullable(this.carrier);
    }

    @Override
    public MainPlayerInventory getMain() {
        if (this.main == null && this.lens instanceof PlayerInventoryLens) {
            this.main = (MainPlayerInventoryAdapter)((PlayerInventoryLens)this.lens).getMainLens().getAdapter(this.inventory, this);
        }
        return this.main;
    }

    @Override
    public EquipmentInventory getEquipment() {
        if (this.equipment == null) {
            this.equipment = (EquipmentInventoryAdapter)((PlayerInventoryLens)this.lens).getEquipmentLens().getAdapter(this.inventory, this);
        }
        return this.equipment;
    }

    @Override
    public Slot getOffhand() {
        if (this.offhand == null && this.lens instanceof PlayerInventoryLens) {
            this.offhand = (SlotAdapter)((PlayerInventoryLens)this.lens).getOffhandLens().getAdapter(this.inventory, this);
        }
        return this.offhand;
    }

    @Override
    public void notify(Object source, InventoryEventArgs eventArgs) {
    }

    @Override
    public SlotProvider<IInventory, ItemStack> getSlotProvider() {
        return this.slots;
    }

    @Override
    public void setSelectedItem(int itemIndex, boolean notify) {
        itemIndex %= 9;
        if (notify && this.field_70458_d instanceof EntityPlayerMP) {
            SPacketHeldItemChange packet = new SPacketHeldItemChange(itemIndex);
            ((EntityPlayerMP)this.field_70458_d).field_71135_a.func_147359_a((Packet)packet);
        }
        this.field_70461_c = itemIndex;
    }

    @Overwrite
    public void func_70436_m() {
        for (NonNullList<ItemStack> aitemstack : this.field_184440_g) {
            for (int i = 0; i < aitemstack.size(); ++i) {
                if (((ItemStack)aitemstack.get(i)).func_190926_b()) continue;
                this.field_70458_d.func_146097_a((ItemStack)aitemstack.get(i), true, false);
            }
        }
    }

    @Override
    public int getFirstAvailableSlot(ItemStack itemstack) {
        for (int i = 0; i < this.field_70462_a.size(); ++i) {
            int stackSize = itemstack.func_190916_E();
            if (((ItemStack)this.field_70462_a.get(i)).func_190916_E() == 0) {
                return i;
            }
            if (((ItemStack)this.field_70462_a.get(i)).func_77973_b() == itemstack.func_77973_b() && ((ItemStack)this.field_70462_a.get(i)).func_77985_e() && ((ItemStack)this.field_70462_a.get(i)).func_190916_E() < ((ItemStack)this.field_70462_a.get(i)).func_77976_d() && ((ItemStack)this.field_70462_a.get(i)).func_190916_E() < this.func_70297_j_() && (!((ItemStack)this.field_70462_a.get(i)).func_77981_g() || ((ItemStack)this.field_70462_a.get(i)).func_77952_i() == itemstack.func_77952_i()) && ItemStack.func_77970_a((ItemStack)((ItemStack)this.field_70462_a.get(i)), (ItemStack)itemstack)) {
                stackSize -= (((ItemStack)this.field_70462_a.get(i)).func_77976_d() < this.func_70297_j_() ? ((ItemStack)this.field_70462_a.get(i)).func_77976_d() : this.func_70297_j_()) - ((ItemStack)this.field_70462_a.get(i)).func_190916_E();
            }
            if (stackSize > 0) continue;
            return i;
        }
        return -1;
    }
}

