/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.projectile;

import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.GameRules;
import org.spongepowered.api.entity.projectile.explosive.fireball.SmallFireball;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.interfaces.entity.IMixinGriefer;
import org.spongepowered.common.mixin.core.entity.projectile.MixinEntityFireball;

@Mixin(value={EntitySmallFireball.class})
public abstract class MixinEntitySmallFireball
extends MixinEntityFireball
implements SmallFireball {
    private float damage = 5.0f;

    @ModifyArg(method={"onImpact"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"))
    protected float onAttackEntityFrom(float amount) {
        return this.damage;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setDamage(double damage) {
        this.damage = (float)damage;
    }

    @Override
    public void readFromNbt(NBTTagCompound compound) {
        super.readFromNbt(compound);
        if (compound.func_74764_b("damageAmount")) {
            this.damage = compound.func_74760_g("damageAmount");
        }
    }

    @Override
    public void writeToNbt(NBTTagCompound compound) {
        super.writeToNbt(compound);
        compound.func_74776_a("damageAmount", this.damage);
    }

    @Redirect(method={"onImpact"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/GameRules;getBoolean(Ljava/lang/String;)Z"))
    private boolean onCanGrief(GameRules gameRules, String rule) {
        return gameRules.func_82766_b(rule) && ((IMixinGriefer)((Object)this)).canGrief();
    }
}

