/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.network.rcon;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import net.minecraft.command.ICommandSender;
import net.minecraft.network.rcon.IServer;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.network.rcon.RConThreadBase;
import net.minecraft.network.rcon.RConThreadClient;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.source.RconSource;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.network.rcon.RconConnectionEvent;
import org.spongepowered.api.network.RemoteConnection;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.interfaces.IMixinRConConsoleSource;

@Mixin(value={RConThreadClient.class})
public abstract class MixinRConThreadClient
extends RConThreadBase
implements RemoteConnection {
    @Shadow
    private boolean field_72657_g;
    @Shadow
    private Socket field_72659_h;
    private RConConsoleSource source;

    protected MixinRConThreadClient(IServer p_i45300_1_, String p_i45300_2_) {
        super(p_i45300_1_, p_i45300_2_);
    }

    private void initSource() {
        this.source = new RConConsoleSource(SpongeImpl.getServer());
        MixinRConThreadClient clientThread = this;
        ((IMixinRConConsoleSource)this.source).setConnection((RConThreadClient)clientThread);
    }

    @Override
    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.field_72659_h.getRemoteSocketAddress();
    }

    @Override
    public InetSocketAddress getVirtualHost() {
        return (InetSocketAddress)this.field_72659_h.getLocalSocketAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"run"}, at=@At(value="INVOKE", target="net.minecraft.network.rcon.IServer.handleRConCommand(Ljava/lang/String;)Ljava/lang/String;"))
    public String commandExecutionHook(IServer server, String commandStr) {
        try {
            Socket socket = this.field_72659_h;
            synchronized (socket) {
                SpongeImpl.getServer().func_71187_D().func_71556_a((ICommandSender)this.source, commandStr);
                String logContents = this.source.func_70008_c();
                this.source.func_70007_b();
                return logContents;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Inject(method={"run"}, at={@At(value="INVOKE", target="net.minecraft.network.rcon.RConThreadClient.sendResponse(IILjava/lang/String;)V", shift=At.Shift.BEFORE)})
    public void rconLoginCallback(CallbackInfo ci) throws IOException {
        if (this.source == null) {
            this.initSource();
        }
        Sponge.getCauseStackManager().pushCause(this.source);
        RconConnectionEvent.Login event = SpongeEventFactory.createRconConnectionEventLogin(Sponge.getCauseStackManager().getCurrentCause(), (RconSource)this.source);
        SpongeImpl.postEvent(event);
        Sponge.getCauseStackManager().popCause();
        if (event.isCancelled()) {
            this.field_72657_g = false;
            throw new IOException("Cancelled login");
        }
    }

    @Inject(method={"closeSocket"}, at={@At(value="HEAD")})
    public void rconLogoutCallback(CallbackInfo ci) {
        if (this.source == null) {
            this.initSource();
        }
        if (this.field_72657_g) {
            Sponge.getCauseStackManager().pushCause(this.source);
            SpongeImpl.postEvent(SpongeEventFactory.createRconConnectionEventDisconnect(Sponge.getCauseStackManager().getCurrentCause(), (RconSource)this.source));
            Sponge.getCauseStackManager().popCause();
        }
    }
}

