/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.potion;

import java.util.Locale;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import org.spongepowered.api.effect.potion.PotionEffectType;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.interfaces.potion.IMixinPotion;
import org.spongepowered.common.registry.type.effect.PotionEffectTypeRegistryModule;
import org.spongepowered.common.text.translation.SpongeTranslation;

@Mixin(value={Potion.class})
@Implements(value={@Interface(iface=PotionEffectType.class, prefix="potion$")})
public abstract class MixinPotion
implements PotionEffectType,
IMixinPotion {
    private Translation translation;
    private Translation potionTranslation;
    private String spongeResourceID;

    @Shadow
    public abstract String shadow$func_76393_a();

    @Shadow
    public abstract boolean shadow$func_76403_b();

    @Intrinsic
    public String potion$getId() {
        return this.spongeResourceID;
    }

    @Intrinsic
    public boolean potion$isInstant() {
        return this.isInstant();
    }

    @Intrinsic
    public String potion$getName() {
        return this.shadow$func_76393_a();
    }

    @Override
    public Translation getTranslation() {
        if (this.translation == null) {
            this.translation = new SpongeTranslation(this.shadow$func_76393_a());
        }
        return this.translation;
    }

    @Override
    public Translation getPotionTranslation() {
        if (this.potionTranslation == null) {
            this.potionTranslation = new SpongeTranslation(this.shadow$func_76393_a() + ".postfix");
        }
        return this.potionTranslation;
    }

    @Override
    public void setId(String id) {
        this.spongeResourceID = id;
    }

    @Redirect(method={"registerPotions"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/registry/RegistryNamespaced;register(ILjava/lang/Object;Ljava/lang/Object;)V"))
    private static void onPotionRegister(RegistryNamespaced registry, int id, Object location, Object potion) {
        ResourceLocation resource = (ResourceLocation)location;
        Potion mcPotion = (Potion)potion;
        ((IMixinPotion)mcPotion).setId(resource.toString().toLowerCase(Locale.ENGLISH));
        PotionEffectTypeRegistryModule.getInstance().registerFromGameData(resource.toString(), (PotionEffectType)mcPotion);
        registry.func_177775_a(id, location, potion);
    }
}

