/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.scoreboard;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.text.TextFormatting;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.scoreboard.CollisionRule;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.Visibility;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.interfaces.IMixinTeam;
import org.spongepowered.common.registry.type.text.TextColorRegistryModule;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.text.format.SpongeTextColor;

@Mixin(value={ScorePlayerTeam.class})
@Implements(value={@Interface(iface=org.spongepowered.api.scoreboard.Team.class, prefix="team$")})
public abstract class MixinScorePlayerTeam
extends Team
implements IMixinTeam {
    @Shadow
    public net.minecraft.scoreboard.Scoreboard field_96677_a;
    @Shadow
    public String field_96675_b;
    @Shadow
    public Set<String> field_96676_c;
    @Shadow
    public String field_96673_d;
    @Shadow
    public TextFormatting field_178777_k;
    @Shadow
    public String field_96674_e;
    @Shadow
    public String field_96671_f;
    @Shadow
    public boolean field_96672_g;
    @Shadow
    public boolean field_98301_h;
    @Shadow
    public Team.EnumVisible field_178778_i;
    @Shadow
    public Team.EnumVisible field_178776_j;
    @Shadow
    public Team.CollisionRule field_186683_l;
    private Text spongeDisplayName;
    private Text spongePrefix;
    private Text spongeSuffix;
    private TextColor spongeColor;
    private static final String TEAM_UPDATE_SIGNATURE = "Lnet/minecraft/scoreboard/Scoreboard;broadcastTeamInfoUpdate(Lnet/minecraft/scoreboard/ScorePlayerTeam;)V";

    @Shadow
    public abstract void func_96660_a(boolean var1);

    private void doTeamUpdate() {
        if (this.field_96677_a != null) {
            this.field_96677_a.func_96538_b((ScorePlayerTeam)this);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void onInit(CallbackInfo ci) {
        this.spongeDisplayName = SpongeTexts.fromLegacy(this.field_96673_d);
        this.spongePrefix = SpongeTexts.fromLegacy(this.field_96674_e);
        this.spongeSuffix = SpongeTexts.fromLegacy(this.field_96671_f);
        this.spongeColor = TextColorRegistryModule.enumChatColor.get(this.field_178777_k);
    }

    public String team$getName() {
        return this.field_96675_b;
    }

    public Text team$getDisplayName() {
        return this.spongeDisplayName;
    }

    public void team$setDisplayName(Text text) {
        String newText = SpongeTexts.toLegacy(text);
        if (newText.length() > 32) {
            throw new IllegalArgumentException(String.format("Display name is %s characters long! It must be at most 32.", newText.length()));
        }
        this.spongeDisplayName = text;
        this.field_96673_d = newText;
        this.doTeamUpdate();
    }

    public TextColor team$getColor() {
        return this.spongeColor;
    }

    public void team$setColor(TextColor color) {
        this.spongeColor = color;
        this.field_178777_k = ((SpongeTextColor)color).getHandle();
        this.doTeamUpdate();
    }

    public Text team$getPrefix() {
        return this.spongePrefix;
    }

    public void team$setPrefix(Text prefix) {
        String newPrefix = SpongeTexts.toLegacy(prefix);
        if (newPrefix.length() > 16) {
            throw new IllegalArgumentException(String.format("Prefix is %s characters long! It must be at most 16.", newPrefix.length()));
        }
        this.spongePrefix = prefix;
        this.field_96674_e = newPrefix;
        this.doTeamUpdate();
    }

    public Text team$getSuffix() {
        return this.spongeSuffix;
    }

    public void team$setSuffix(Text suffix) {
        String newSuffix = SpongeTexts.toLegacy(suffix);
        if (newSuffix.length() > 16) {
            throw new IllegalArgumentException(String.format("Suffix is %s characters long! It must be at most 16.", newSuffix.length()));
        }
        this.spongeSuffix = suffix;
        this.field_96671_f = newSuffix;
        this.doTeamUpdate();
    }

    public boolean team$allowFriendlyFire() {
        return this.field_96672_g;
    }

    @Intrinsic
    public void team$setAllowFriendlyFire(boolean allowFriendlyFire) {
        this.func_96660_a(allowFriendlyFire);
    }

    public boolean team$canSeeFriendlyInvisibles() {
        return this.field_98301_h;
    }

    public void team$setCanSeeFriendlyInvisibles(boolean enabled) {
        this.field_98301_h = enabled;
        this.doTeamUpdate();
    }

    public Visibility team$getNameTagVisibility() {
        return (Visibility)this.field_178778_i;
    }

    public void team$setNameTagVisibility(Visibility visibility) {
        this.field_178778_i = (Team.EnumVisible)visibility;
        this.doTeamUpdate();
    }

    public Visibility team$getDeathMessageVisibility() {
        return (Visibility)this.field_178776_j;
    }

    public void team$setDeathMessageVisibility(Visibility visibility) {
        this.field_178776_j = (Team.EnumVisible)visibility;
        this.doTeamUpdate();
    }

    public CollisionRule team$getCollisionRule() {
        return (CollisionRule)this.field_186683_l;
    }

    public void team$setCollisionRule(CollisionRule rule) {
        this.field_186683_l = (Team.CollisionRule)rule;
        this.doTeamUpdate();
    }

    public Set<Text> team$getMembers() {
        return this.field_96676_c.stream().map(SpongeTexts::fromLegacy).collect(Collectors.toSet());
    }

    public void team$addMember(Text member) {
        String legacyName = SpongeTexts.toLegacy(member);
        if (legacyName.length() > 40) {
            throw new IllegalArgumentException(String.format("Member is %s characters long! It must be at most 40.", legacyName.length()));
        }
        if (this.field_96677_a != null) {
            this.field_96677_a.func_151392_a(legacyName, this.field_96675_b);
        } else {
            this.field_96676_c.add(legacyName);
        }
    }

    public boolean team$removeMember(Text member) {
        String legacyName = SpongeTexts.toLegacy(member);
        if (this.field_96677_a != null) {
            ScorePlayerTeam realTeam = this.field_96677_a.func_96509_i(legacyName);
            if (realTeam == (ScorePlayerTeam)this) {
                this.field_96677_a.func_96512_b(legacyName, realTeam);
                return true;
            }
            return false;
        }
        return this.field_96676_c.remove(legacyName);
    }

    public Optional<Scoreboard> team$getScoreboard() {
        return Optional.ofNullable((Scoreboard)this.field_96677_a);
    }

    public boolean team$unregister() {
        if (this.field_96677_a == null) {
            return false;
        }
        this.field_96677_a.func_96511_d((ScorePlayerTeam)this);
        this.field_96677_a = null;
        return true;
    }

    @Redirect(method={"setDisplayName"}, at=@At(value="INVOKE", target="Lnet/minecraft/scoreboard/Scoreboard;broadcastTeamInfoUpdate(Lnet/minecraft/scoreboard/ScorePlayerTeam;)V"))
    private void onSetTeamName(net.minecraft.scoreboard.Scoreboard scoreboard, ScorePlayerTeam team) {
        this.doTeamUpdate();
    }

    @Inject(method={"setDisplayName"}, at={@At(value="HEAD")})
    public void onSetTeamName(String name, CallbackInfo ci) {
        if (name != null) {
            this.spongeDisplayName = SpongeTexts.fromLegacy(name);
        }
    }

    @Redirect(method={"setPrefix"}, at=@At(value="INVOKE", target="Lnet/minecraft/scoreboard/Scoreboard;broadcastTeamInfoUpdate(Lnet/minecraft/scoreboard/ScorePlayerTeam;)V"))
    private void onSetNamePrefix(net.minecraft.scoreboard.Scoreboard scoreboard, ScorePlayerTeam team) {
        this.doTeamUpdate();
    }

    @Inject(method={"setPrefix"}, at={@At(value="HEAD")})
    public void onSetNamePrefix(String prefix, CallbackInfo ci) {
        if (prefix != null) {
            this.spongePrefix = SpongeTexts.fromLegacy(prefix);
        }
    }

    @Redirect(method={"setSuffix"}, at=@At(value="INVOKE", target="Lnet/minecraft/scoreboard/Scoreboard;broadcastTeamInfoUpdate(Lnet/minecraft/scoreboard/ScorePlayerTeam;)V"))
    private void onSetNameSuffix(net.minecraft.scoreboard.Scoreboard scoreboard, ScorePlayerTeam team) {
        this.doTeamUpdate();
    }

    @Inject(method={"setSuffix"}, at={@At(value="HEAD")})
    public void onSetNameSuffix(String suffix, CallbackInfo ci) {
        if (suffix != null) {
            this.spongeSuffix = SpongeTexts.fromLegacy(suffix);
        }
    }

    @Redirect(method={"setAllowFriendlyFire"}, at=@At(value="INVOKE", target="Lnet/minecraft/scoreboard/Scoreboard;broadcastTeamInfoUpdate(Lnet/minecraft/scoreboard/ScorePlayerTeam;)V"))
    private void onSetAllowFriendlyFire(net.minecraft.scoreboard.Scoreboard scoreboard, ScorePlayerTeam team) {
        this.doTeamUpdate();
    }

    @Redirect(method={"setSeeFriendlyInvisiblesEnabled"}, at=@At(value="INVOKE", target="Lnet/minecraft/scoreboard/Scoreboard;broadcastTeamInfoUpdate(Lnet/minecraft/scoreboard/ScorePlayerTeam;)V"))
    private void onSetSeeFriendlyInvisiblesEnabled(net.minecraft.scoreboard.Scoreboard scoreboard, ScorePlayerTeam team) {
        this.doTeamUpdate();
    }

    @Redirect(method={"setNameTagVisibility"}, at=@At(value="INVOKE", target="Lnet/minecraft/scoreboard/Scoreboard;broadcastTeamInfoUpdate(Lnet/minecraft/scoreboard/ScorePlayerTeam;)V"))
    private void onSetNameTagVisibility(net.minecraft.scoreboard.Scoreboard scoreboard, ScorePlayerTeam team) {
        this.doTeamUpdate();
    }

    @Redirect(method={"setDeathMessageVisibility"}, at=@At(value="INVOKE", target="Lnet/minecraft/scoreboard/Scoreboard;broadcastTeamInfoUpdate(Lnet/minecraft/scoreboard/ScorePlayerTeam;)V"))
    private void onSetDeathMessageVisibility(net.minecraft.scoreboard.Scoreboard scoreboard, ScorePlayerTeam team) {
        this.doTeamUpdate();
    }

    @Inject(method={"setColor"}, at={@At(value="RETURN")})
    private void onSetChatFormat(TextFormatting format, CallbackInfo ci) {
        this.spongeColor = TextColorRegistryModule.enumChatColor.get(format);
        this.doTeamUpdate();
    }

    public MessageChannel getChannel() {
        return MessageChannel.fixed(this.func_96670_d().stream().map(name -> Sponge.getGame().getServer().getPlayer((String)name)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet()));
    }

    @Override
    public MessageChannel getTeamChannel(EntityPlayerMP player) {
        return MessageChannel.fixed(this.func_96670_d().stream().map(name -> Sponge.getGame().getServer().getPlayer((String)name)).filter(Optional::isPresent).map(Optional::get).filter(member -> member != player).collect(Collectors.toSet()));
    }

    @Override
    public MessageChannel getNonTeamChannel() {
        return MessageChannel.fixed(Sponge.getGame().getServer().getOnlinePlayers().stream().filter(player -> ((EntityPlayerMP)player).func_96124_cp() != this).collect(Collectors.toSet()));
    }
}

