/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.scoreboard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketDisplayObjective;
import net.minecraft.network.play.server.SPacketScoreboardObjective;
import net.minecraft.network.play.server.SPacketTeams;
import net.minecraft.network.play.server.SPacketUpdateScore;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.interfaces.IMixinServerScoreboard;

@Mixin(value={ServerScoreboard.class})
public abstract class MixinServerScoreboardPacketSending
extends Scoreboard
implements IMixinServerScoreboard {
    private static final String SEND_PACKET_METHOD = "Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V";
    private static final String SET_CONTAINS = "Ljava/util/Set;contains(Ljava/lang/Object;)Z";
    @Shadow
    @Final
    private MinecraftServer field_96555_a;
    private List<EntityPlayerMP> players = new ArrayList<EntityPlayerMP>();

    @Override
    public void sendToPlayers(Packet<?> packet) {
        for (EntityPlayerMP player : this.players) {
            player.field_71135_a.func_147359_a(packet);
        }
    }

    @Override
    public void addPlayer(EntityPlayerMP player) {
        this.players.add(player);
        this.sendScoreboard(player);
    }

    void sendScoreboard(EntityPlayerMP player) {
        for (ScorePlayerTeam team : this.func_96525_g()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketTeams(team, 0));
        }
        for (ScoreObjective objective : this.func_96514_c()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketScoreboardObjective(objective, 0));
            for (Score score : this.func_96534_i(objective)) {
                player.field_71135_a.func_147359_a((Packet)new SPacketUpdateScore(score));
            }
        }
        for (int i = 0; i < 19; ++i) {
            player.field_71135_a.func_147359_a((Packet)new SPacketDisplayObjective(i, this.func_96539_a(i)));
        }
    }

    @Override
    public void removePlayer(EntityPlayerMP player, boolean sendPackets) {
        this.players.remove(player);
        if (sendPackets) {
            this.removeScoreboard(player);
        }
    }

    void removeScoreboard(EntityPlayerMP player) {
        this.removeTeams(player);
        this.removeObjectives(player);
    }

    void removeTeams(EntityPlayerMP player) {
        for (ScorePlayerTeam team : this.func_96525_g()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketTeams(team, 1));
        }
    }

    void removeObjectives(EntityPlayerMP player) {
        for (ScoreObjective objective : this.func_96514_c()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketScoreboardObjective(objective, 1));
        }
    }

    @Redirect(method={"onScoreUpdated"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V"))
    public void onUpdateScoreValue(PlayerList manager, Packet<?> packet) {
        this.sendToPlayers(packet);
    }

    @Redirect(method={"onScoreUpdated"}, at=@At(value="INVOKE", target="Ljava/util/Set;contains(Ljava/lang/Object;)Z", remap=false))
    public boolean onUpdateScoreValue(Set<?> set, Object object) {
        return true;
    }

    @Redirect(method={"broadcastScoreUpdate(Ljava/lang/String;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V"))
    public void onRemoveScore(PlayerList manager, Packet<?> packet) {
        this.sendToPlayers(packet);
    }

    @Redirect(method={"broadcastScoreUpdate(Ljava/lang/String;Lnet/minecraft/scoreboard/ScoreObjective;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V"))
    public void onRemoveScoreForObjective(PlayerList manager, Packet<?> packet) {
        this.sendToPlayers(packet);
    }

    @Redirect(method={"addPlayerToTeam"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V"))
    public void onAddPlayerToTeam(PlayerList manager, Packet<?> packet) {
        this.sendToPlayers(packet);
    }

    @Redirect(method={"removePlayerFromTeam"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V"))
    public void onRemovePlayerFromTeam(PlayerList manager, Packet<?> packet) {
        this.sendToPlayers(packet);
    }

    @Redirect(method={"onObjectiveDisplayNameChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V"))
    public void onUpdateObjective(PlayerList manager, Packet<?> packet) {
        this.sendToPlayers(packet);
    }

    @Redirect(method={"onObjectiveDisplayNameChanged"}, at=@At(value="INVOKE", target="Ljava/util/Set;contains(Ljava/lang/Object;)Z", remap=false))
    public boolean onUpdateObjective(Set<ScoreObjective> set, Object object) {
        return true;
    }

    @Redirect(method={"onScoreObjectiveRemoved"}, at=@At(value="INVOKE", target="Ljava/util/Set;contains(Ljava/lang/Object;)Z", remap=false))
    public boolean onSendDisplayPackets(Set<ScoreObjective> set, Object object) {
        return true;
    }

    @Redirect(method={"broadcastTeamCreated"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V"))
    public void onBroadcastTeamCreated(PlayerList manager, Packet<?> packet) {
        this.sendToPlayers(packet);
    }

    @Redirect(method={"broadcastTeamInfoUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V"))
    public void onSendTeamUpdate(PlayerList manager, Packet<?> packet) {
        this.sendToPlayers(packet);
    }

    @Redirect(method={"broadcastTeamRemove"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V"))
    public void onRemoveTeam(PlayerList manager, Packet<?> packet) {
        this.sendToPlayers(packet);
    }

    @Redirect(method={"addObjective"}, at=@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;", ordinal=0, remap=false))
    public Iterator onGetPlayerIteratorForObjectives(List list) {
        return this.players.iterator();
    }

    @Redirect(method={"sendDisplaySlotRemovalPackets"}, at=@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;", ordinal=0, remap=false))
    public Iterator onGetPlayerIterator(List list) {
        return this.players.iterator();
    }
}

