/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server;

import java.net.InetSocketAddress;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.Server;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;

@Mixin(value={DedicatedServer.class})
public abstract class MixinDedicatedServer
extends MinecraftServer
implements Server {
    @Shadow
    private boolean field_71335_s;

    @Shadow
    public abstract String func_71277_t();

    @Shadow
    public abstract int func_71234_u();

    public MixinDedicatedServer() {
        super(null, null, null, null, null, null, null);
    }

    @Override
    public Optional<InetSocketAddress> getBoundAddress() {
        if (this.func_71277_t() == null) {
            return Optional.empty();
        }
        return Optional.of(new InetSocketAddress(this.func_71277_t(), this.func_71234_u()));
    }

    @Overwrite
    public void func_120011_ar() {
        this.field_71335_s = false;
    }

    @Inject(method={"systemExitNow"}, at={@At(value="HEAD")})
    public void postGameStoppingEvent(CallbackInfo ci) {
        SpongeImpl.postShutdownEvents();
    }

    @Overwrite
    public boolean func_175579_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        CauseTracker causeTracker = CauseTracker.getInstance();
        PhaseData peek = causeTracker.getCurrentPhaseData();
        IPhaseState phaseState = peek.state;
        if ((phaseState == null || !phaseState.isInteraction()) && SpongeCommonEventFactory.callChangeBlockEventPre((IMixinWorldServer)worldIn, pos, (Object)playerIn).isCancelled()) {
            return true;
        }
        BlockPos spawnPoint = worldIn.func_175694_M();
        int protectionRadius = this.func_82357_ak();
        return protectionRadius > 0 && Math.max(Math.abs(pos.func_177958_n() - spawnPoint.func_177958_n()), Math.abs(pos.func_177952_p() - spawnPoint.func_177952_p())) <= protectionRadius && !((Player)playerIn).hasPermission("minecraft.spawn-protection.override");
    }
}

