/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.tileentity;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.block.tileentity.carrier.Hopper;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.mutable.tileentity.CooldownData;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.comp.GridInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.MinecraftLens;
import org.spongepowered.common.item.inventory.lens.impl.ReusableLens;
import org.spongepowered.common.item.inventory.lens.impl.collections.SlotCollection;
import org.spongepowered.common.item.inventory.lens.impl.comp.GridInventoryLensImpl;
import org.spongepowered.common.mixin.core.tileentity.MixinTileEntityLockableLoot;

@NonnullByDefault
@Mixin(value={TileEntityHopper.class})
public abstract class MixinTileEntityHopper
extends MixinTileEntityLockableLoot
implements Hopper {
    @Shadow
    private int field_145901_j;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void onConstructed(CallbackInfo ci) {
        ReusableLens<GridInventoryLens> reusableLens = MinecraftLens.getLens(GridInventoryLens.class, (InventoryAdapter)((Object)this), s -> new GridInventoryLensImpl(0, 5, 1, 5, (SlotProvider<IInventory, ItemStack>)s), () -> new SlotCollection.Builder().add(5).build());
        this.slots = reusableLens.getSlots();
        this.lens = reusableLens.getLens();
    }

    @Inject(method={"putDropInInventoryAllSlots"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/EntityItem;getItem()Lnet/minecraft/item/ItemStack;")})
    private static void onPutDrop(IInventory inventory, IInventory hopper, EntityItem entityItem, CallbackInfoReturnable<Boolean> callbackInfo) {
        ((IMixinEntity)entityItem).getCreatorUser().ifPresent(owner -> {
            if (inventory instanceof TileEntity) {
                TileEntity te = (TileEntity)inventory;
                BlockPos pos = te.func_174877_v();
                IMixinChunk spongeChunk = (IMixinChunk)te.func_145831_w().func_175726_f(pos);
                spongeChunk.addTrackedBlockPosition(te.func_145838_q(), pos, (User)owner, PlayerTracker.Type.NOTIFIER);
            }
        });
    }

    @Override
    public DataContainer toContainer() {
        DataContainer container = super.toContainer();
        return container.set(DataQuery.of("TransferCooldown"), (Object)this.field_145901_j);
    }

    @Override
    public void supplyVanillaManipulators(List<DataManipulator<?, ?>> manipulators) {
        super.supplyVanillaManipulators(manipulators);
        Optional<CooldownData> cooldownData = this.get(CooldownData.class);
        if (cooldownData.isPresent()) {
            manipulators.add(cooldownData.get());
        }
    }
}

