/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.biome;

import com.google.common.base.Preconditions;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.type.PlantTypes;
import org.spongepowered.api.data.type.ShrubTypes;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.util.weighted.ChanceTable;
import org.spongepowered.api.util.weighted.EmptyObject;
import org.spongepowered.api.util.weighted.SeededVariableAmount;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedObject;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.BiomeGenerationSettings;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.biome.GroundCoverLayer;
import org.spongepowered.api.world.gen.populator.BigMushroom;
import org.spongepowered.api.world.gen.populator.Cactus;
import org.spongepowered.api.world.gen.populator.DeadBush;
import org.spongepowered.api.world.gen.populator.Flower;
import org.spongepowered.api.world.gen.populator.Forest;
import org.spongepowered.api.world.gen.populator.Mushroom;
import org.spongepowered.api.world.gen.populator.Ore;
import org.spongepowered.api.world.gen.populator.Pumpkin;
import org.spongepowered.api.world.gen.populator.RandomBlock;
import org.spongepowered.api.world.gen.populator.Reed;
import org.spongepowered.api.world.gen.populator.SeaFloor;
import org.spongepowered.api.world.gen.populator.Shrub;
import org.spongepowered.api.world.gen.populator.WaterLily;
import org.spongepowered.api.world.gen.type.BiomeTreeTypes;
import org.spongepowered.api.world.gen.type.MushroomType;
import org.spongepowered.api.world.gen.type.MushroomTypes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.interfaces.world.biome.IMixinBiome;
import org.spongepowered.common.world.biome.SpongeBiomeGenerationSettings;
import org.spongepowered.common.world.gen.WorldGenConstants;
import org.spongepowered.common.world.gen.populators.WrappedBiomeDecorator;

@NonnullByDefault
@Mixin(value={Biome.class})
public abstract class MixinBiome
implements BiomeType,
IMixinBiome {
    @Shadow
    @Final
    public String field_76791_y;
    @Shadow
    @Final
    public float field_76750_F;
    @Shadow
    @Final
    public float field_76751_G;
    @Shadow
    public IBlockState field_76752_A;
    @Shadow
    public IBlockState field_76753_B;
    @Shadow
    public BiomeDecorator field_76760_I;
    private String id;
    private String modId;

    @Override
    public BiomeGenerationSettings createDefaultGenerationSettings(World world) {
        SpongeBiomeGenerationSettings gensettings = new SpongeBiomeGenerationSettings();
        gensettings.getPopulators().clear();
        gensettings.getGenerationPopulators().clear();
        gensettings.getGroundCoverLayers().clear();
        this.buildPopulators((net.minecraft.world.World)world, gensettings);
        if (!this.getClass().getName().startsWith("net.minecraft")) {
            gensettings.getPopulators().add(new WrappedBiomeDecorator((Biome)this));
        } else if (!this.field_76760_I.getClass().getName().startsWith("net.minecraft")) {
            gensettings.getPopulators().add(new WrappedBiomeDecorator(this.field_76760_I));
        }
        return gensettings;
    }

    @Override
    public void buildPopulators(net.minecraft.world.World world, SpongeBiomeGenerationSettings gensettings) {
        BiomeDecorator theBiomeDecorator = this.field_76760_I;
        gensettings.getGroundCoverLayers().add(new GroundCoverLayer((BlockState)this.field_76752_A, SeededVariableAmount.fixed(1.0)));
        gensettings.getGroundCoverLayers().add(new GroundCoverLayer((BlockState)this.field_76753_B, WorldGenConstants.GROUND_COVER_DEPTH));
        String s = world.func_72912_H().func_82571_y();
        ChunkGeneratorSettings settings = s != null ? ChunkGeneratorSettings.Factory.func_177865_a((String)s).func_177864_b() : ChunkGeneratorSettings.Factory.func_177865_a((String)"").func_177864_b();
        Ore dirt = Ore.builder().ore((BlockState)Blocks.field_150346_d.func_176223_P()).size(settings.field_177789_I).perChunk(settings.field_177790_J).height(VariableAmount.baseWithRandomAddition((double)settings.field_177791_K, settings.field_177784_L - settings.field_177791_K)).build();
        gensettings.getPopulators().add(dirt);
        Ore gravel = Ore.builder().ore((BlockState)Blocks.field_150351_n.func_176223_P()).size(settings.field_177785_M).perChunk(settings.field_177786_N).height(VariableAmount.baseWithRandomAddition((double)settings.field_177787_O, settings.field_177797_P - settings.field_177787_O)).build();
        gensettings.getPopulators().add(gravel);
        Ore diorite = Ore.builder().ore((BlockState)Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE)).size(settings.field_177792_U).perChunk(settings.field_177795_V).height(VariableAmount.baseWithRandomAddition((double)settings.field_177794_W, settings.field_177801_X - settings.field_177794_W)).build();
        gensettings.getPopulators().add(diorite);
        Ore granite = Ore.builder().ore((BlockState)Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE)).size(settings.field_177796_Q).perChunk(settings.field_177799_R).height(VariableAmount.baseWithRandomAddition((double)settings.field_177798_S, settings.field_177793_T - settings.field_177798_S)).build();
        gensettings.getPopulators().add(granite);
        Ore andesite = Ore.builder().ore((BlockState)Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE)).size(settings.field_177800_Y).perChunk(settings.field_177802_Z).height(VariableAmount.baseWithRandomAddition((double)settings.field_177846_aa, settings.field_177847_ab - settings.field_177846_aa)).build();
        gensettings.getPopulators().add(andesite);
        Ore coal = Ore.builder().ore((BlockState)Blocks.field_150365_q.func_176223_P()).size(settings.field_177844_ac).perChunk(settings.field_177845_ad).height(VariableAmount.baseWithRandomAddition((double)settings.field_177851_ae, settings.field_177853_af - settings.field_177851_ae)).build();
        gensettings.getPopulators().add(coal);
        Ore iron = Ore.builder().ore((BlockState)Blocks.field_150366_p.func_176223_P()).size(settings.field_177848_ag).perChunk(settings.field_177849_ah).height(VariableAmount.baseWithRandomAddition((double)settings.field_177832_ai, settings.field_177834_aj - settings.field_177832_ai)).build();
        gensettings.getPopulators().add(iron);
        Ore gold = Ore.builder().ore((BlockState)Blocks.field_150352_o.func_176223_P()).size(settings.field_177828_ak).perChunk(settings.field_177830_al).height(VariableAmount.baseWithRandomAddition((double)settings.field_177840_am, settings.field_177842_an - settings.field_177840_am)).build();
        gensettings.getPopulators().add(gold);
        Ore redstone = Ore.builder().ore((BlockState)Blocks.field_150450_ax.func_176223_P()).size(settings.field_177836_ao).perChunk(settings.field_177838_ap).height(VariableAmount.baseWithRandomAddition((double)settings.field_177818_aq, settings.field_177816_ar - settings.field_177818_aq)).build();
        gensettings.getPopulators().add(redstone);
        Ore diamond = Ore.builder().ore((BlockState)Blocks.field_150482_ag.func_176223_P()).size(settings.field_177814_as).perChunk(settings.field_177812_at).height(VariableAmount.baseWithRandomAddition((double)settings.field_177826_au, settings.field_177824_av - settings.field_177826_au)).build();
        gensettings.getPopulators().add(diamond);
        Ore lapis = Ore.builder().ore((BlockState)Blocks.field_150369_x.func_176223_P()).size(settings.field_177822_aw).perChunk(settings.field_177820_ax).height(VariableAmount.baseWithVariance((double)settings.field_177807_ay, settings.field_177805_az)).build();
        gensettings.getPopulators().add(lapis);
        if (theBiomeDecorator.field_76805_H > 0) {
            SeaFloor sand = SeaFloor.builder().block((BlockState)Blocks.field_150354_m.func_176223_P()).radius(VariableAmount.baseWithRandomAddition(2.0, 5.0)).depth(2).perChunk(theBiomeDecorator.field_76805_H).replace(WorldGenConstants.DIRT_OR_GRASS).build();
            gensettings.getPopulators().add(sand);
        }
        if (theBiomeDecorator.field_76806_I > 0) {
            SeaFloor clay = SeaFloor.builder().block((BlockState)Blocks.field_150435_aG.func_176223_P()).radius(VariableAmount.baseWithRandomAddition(2.0, 2.0)).depth(1).perChunk(theBiomeDecorator.field_76806_I).replace(WorldGenConstants.DIRT).build();
            gensettings.getPopulators().add(clay);
        }
        if (theBiomeDecorator.field_76801_G > 0) {
            SeaFloor gravelSeaFloor = SeaFloor.builder().block((BlockState)Blocks.field_150351_n.func_176223_P()).radius(VariableAmount.baseWithRandomAddition(2.0, 4.0)).depth(2).perChunk(theBiomeDecorator.field_76801_G).replace(WorldGenConstants.DIRT_OR_GRASS).build();
            gensettings.getPopulators().add(gravelSeaFloor);
        }
        Forest forest = Forest.builder().type(BiomeTreeTypes.OAK.getPopulatorObject(), 9.0).type(BiomeTreeTypes.OAK.getLargePopulatorObject().get(), 1.0).perChunk(VariableAmount.baseWithOptionalAddition((double)theBiomeDecorator.field_76832_z, 1.0, 0.1)).build();
        gensettings.getPopulators().add(forest);
        if (theBiomeDecorator.field_76807_J > 0) {
            BigMushroom mushroom = BigMushroom.builder().mushroomsPerChunk(theBiomeDecorator.field_76807_J).type(MushroomTypes.BROWN.getPopulatorObject(), 1.0).type(MushroomTypes.RED.getPopulatorObject(), 1.0).build();
            gensettings.getPopulators().add(mushroom);
        }
        if (theBiomeDecorator.field_76802_A > 0) {
            Flower flower = Flower.builder().perChunk(theBiomeDecorator.field_76802_A * 64).type(PlantTypes.DANDELION, 2.0).type(PlantTypes.POPPY, 1.0).build();
            gensettings.getPopulators().add(flower);
        }
        if (theBiomeDecorator.field_76803_B > 0) {
            Shrub grass = Shrub.builder().perChunk(theBiomeDecorator.field_76803_B * 128).type(ShrubTypes.TALL_GRASS, 1).build();
            gensettings.getPopulators().add(grass);
        }
        if (theBiomeDecorator.field_76804_C > 0) {
            DeadBush deadBush = DeadBush.builder().perChunk(theBiomeDecorator.field_76804_C).build();
            gensettings.getPopulators().add(deadBush);
        }
        if (theBiomeDecorator.field_76833_y > 0) {
            WaterLily waterLily = WaterLily.builder().perChunk(theBiomeDecorator.field_76833_y * 10).build();
            gensettings.getPopulators().add(waterLily);
        }
        ChanceTable<MushroomType> types = new ChanceTable<MushroomType>();
        types.add((TableEntry<MushroomType>)new WeightedObject<MushroomType>(MushroomTypes.BROWN, 2.0));
        types.add((TableEntry<MushroomType>)new WeightedObject<MushroomType>(MushroomTypes.RED, 1.0));
        types.add(new EmptyObject(5.0));
        Mushroom smallMushroom = Mushroom.builder().types(types).mushroomsPerChunk(theBiomeDecorator.field_76798_D + 1).build();
        gensettings.getPopulators().add(smallMushroom);
        Reed reed = Reed.builder().perChunk(theBiomeDecorator.field_76799_E + 10).reedHeight(VariableAmount.baseWithRandomAddition(2.0, VariableAmount.baseWithRandomAddition(1.0, 3.0))).build();
        gensettings.getPopulators().add(reed);
        Pumpkin pumpkin = Pumpkin.builder().perChunk(64).chance(0.03125).build();
        gensettings.getPopulators().add(pumpkin);
        if (theBiomeDecorator.field_76800_F > 0) {
            Cactus cactus = Cactus.builder().cactiPerChunk(VariableAmount.baseWithOptionalAddition(0.0, VariableAmount.baseWithRandomAddition(1.0, VariableAmount.baseWithOptionalAddition(2.0, 3.0, 0.5)), 0.8)).build();
            gensettings.getPopulators().add(cactus);
        }
        if (theBiomeDecorator.field_76808_K) {
            RandomBlock water = RandomBlock.builder().block((BlockState)Blocks.field_150358_i.func_176223_P()).height(VariableAmount.baseWithRandomAddition(0.0, VariableAmount.baseWithRandomAddition(8.0, 248.0))).perChunk(50).placementTarget(WorldGenConstants.CAVE_LIQUIDS).build();
            gensettings.getPopulators().add(water);
            RandomBlock lava = RandomBlock.builder().block((BlockState)Blocks.field_150356_k.func_176223_P()).height(VariableAmount.baseWithRandomAddition(0.0, VariableAmount.baseWithRandomAddition(8.0, VariableAmount.baseWithRandomAddition(8.0, 240.0)))).perChunk(20).placementTarget(WorldGenConstants.CAVE_LIQUIDS).build();
            gensettings.getPopulators().add(lava);
        }
    }

    @Inject(method={"registerBiome"}, at={@At(value="HEAD")})
    private static void onRegisterBiome(int id, String name, Biome biome, CallbackInfo ci) {
        String modId = SpongeImplHooks.getModIdFromClass(biome.getClass());
        String biomeName = name.toLowerCase().replace(" ", "_").replaceAll("[^A-Za-z0-9_]", "");
        ((IMixinBiome)biome).setModId(modId);
        ((IMixinBiome)biome).setId(modId + ":" + biomeName);
    }

    @Override
    public String getName() {
        return this.field_76791_y;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        Preconditions.checkState((this.id == null ? 1 : 0) != 0, (Object)"Attempt made to set ID!");
        this.id = id;
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    @Override
    public void setModId(String modId) {
        Preconditions.checkState((this.modId == null ? 1 : 0) != 0, (Object)"Attempt made to set Mod ID!");
        this.modId = modId;
    }

    @Override
    public double getTemperature() {
        return this.field_76750_F;
    }

    @Override
    public double getHumidity() {
        return this.field_76751_G;
    }
}

