/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.interfaces.IMixinSaveHandler;
import org.spongepowered.common.interfaces.world.IMixinWorldInfo;
import org.spongepowered.common.world.WorldManager;
import org.spongepowered.common.world.storage.SpongePlayerDataHandler;

@NonnullByDefault
@Mixin(value={SaveHandler.class})
public abstract class MixinSaveHandler
implements IMixinSaveHandler {
    private static final String COMPRESSED_READ_FILE = "Lnet/minecraft/nbt/CompressedStreamTools;readCompressed(Ljava/io/InputStream;)Lnet/minecraft/nbt/NBTTagCompound;";
    private static final String COMPRESSED_WRITE_FILE = "Lnet/minecraft/nbt/CompressedStreamTools;writeCompressed(Lnet/minecraft/nbt/NBTTagCompound;Ljava/io/OutputStream;)V";
    private static final String READ_PLAYER_DATA = "readPlayerData(Lnet/minecraft/entity/player/EntityPlayer;)Lnet/minecraft/nbt/NBTTagCompound;";
    private static final String NBT_COMPOUND_SET = "Lnet/minecraft/nbt/NBTTagCompound;setTag(Ljava/lang/String;Lnet/minecraft/nbt/NBTBase;)V";
    @Shadow
    @Final
    private File field_75770_b;
    @Shadow
    @Final
    private long field_75769_e;
    @Nullable
    private Path file;

    @ModifyArg(method={"checkSessionLock"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/MinecraftException;<init>(Ljava/lang/String;)V", ordinal=0, remap=false))
    public String modifyMinecraftExceptionOutputIfNotInitializationTime(String message) {
        return "The save folder for world " + this.field_75770_b + " is being accessed from another location, aborting";
    }

    @ModifyArg(method={"checkSessionLock"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/MinecraftException;<init>(Ljava/lang/String;)V", ordinal=1, remap=false))
    public String modifyMinecraftExceptionOutputIfIOException(String message) {
        return "Failed to check session lock for world " + this.field_75770_b + ", aborting";
    }

    @Inject(method={"saveWorldInfoWithPlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/NBTTagCompound;setTag(Ljava/lang/String;Lnet/minecraft/nbt/NBTBase;)V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void onSaveWorldInfoWithPlayerAfterTagSet(WorldInfo worldInformation, NBTTagCompound tagCompound, CallbackInfo ci, NBTTagCompound nbttagcompound1, NBTTagCompound nbttagcompound2) {
        this.saveDimensionAndOtherData((SaveHandler)this, worldInformation, nbttagcompound2);
    }

    @Inject(method={"saveWorldInfoWithPlayer"}, at={@At(value="RETURN")})
    public void onSaveWorldInfoWithPlayerEnd(WorldInfo worldInformation, NBTTagCompound tagCompound, CallbackInfo ci) {
        this.saveSpongeDatData(worldInformation);
    }

    @Override
    public void loadSpongeDatData(WorldInfo info) throws IOException {
        File spongeFile = new File(this.field_75770_b, "level_sponge.dat");
        File spongeOldFile = new File(this.field_75770_b, "level_sponge.dat_old");
        if (spongeFile.exists() || spongeOldFile.exists()) {
            NBTTagCompound compound = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(spongeFile.exists() ? spongeFile : spongeOldFile));
            ((IMixinWorldInfo)info).setSpongeRootLevelNBT(compound);
            if (compound.func_74764_b("SpongeData")) {
                NBTTagCompound spongeCompound = compound.func_74775_l("SpongeData");
                DataUtil.spongeDataFixer.func_188257_a((IFixType)FixTypes.LEVEL, spongeCompound);
                ((IMixinWorldInfo)info).readSpongeNbt(spongeCompound);
            }
        }
    }

    private void saveSpongeDatData(WorldInfo info) {
        try {
            File spongeFile1 = new File(this.field_75770_b, "level_sponge.dat_new");
            File spongeFile2 = new File(this.field_75770_b, "level_sponge.dat_old");
            File spongeFile3 = new File(this.field_75770_b, "level_sponge.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)((IMixinWorldInfo)info).getSpongeRootLevelNbt(), (OutputStream)new FileOutputStream(spongeFile1));
            if (spongeFile2.exists()) {
                spongeFile2.delete();
            }
            spongeFile3.renameTo(spongeFile2);
            if (spongeFile3.exists()) {
                spongeFile3.delete();
            }
            spongeFile1.renameTo(spongeFile3);
            if (spongeFile1.exists()) {
                spongeFile1.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void loadDimensionAndOtherData(SaveHandler handler, WorldInfo info, NBTTagCompound compound) {
        NBTTagCompound customWorldDataCompound = compound.func_74775_l("Forge");
        if (customWorldDataCompound.func_74764_b("DimensionData")) {
            WorldManager.loadDimensionDataMap(customWorldDataCompound.func_74775_l("DimensionData"));
        }
    }

    private void saveDimensionAndOtherData(SaveHandler handler, WorldInfo info, NBTTagCompound compound) {
        if (this.field_75770_b.getParentFile() == null || SpongeImpl.getGame().getPlatform().getType().isClient() && this.field_75770_b.getParentFile().equals(SpongeImpl.getGame().getSavesDirectory())) {
            NBTTagCompound customWorldDataCompound = new NBTTagCompound();
            NBTTagCompound customDimensionDataCompound = WorldManager.saveDimensionDataMap();
            customWorldDataCompound.func_74782_a("DimensionData", (NBTBase)customDimensionDataCompound);
            compound.func_74782_a("Forge", (NBTBase)customWorldDataCompound);
        }
    }

    @Redirect(method={"readPlayerData(Lnet/minecraft/entity/player/EntityPlayer;)Lnet/minecraft/nbt/NBTTagCompound;"}, at=@At(value="INVOKE", target="Ljava/io/File;isFile()Z", remap=false))
    private boolean grabfile(File localfile) {
        boolean isFile = localfile.isFile();
        this.file = isFile ? localfile.toPath() : null;
        return isFile;
    }

    @Redirect(method={"readPlayerData(Lnet/minecraft/entity/player/EntityPlayer;)Lnet/minecraft/nbt/NBTTagCompound;"}, at=@At(value="INVOKE", target="Lnet/minecraft/nbt/CompressedStreamTools;readCompressed(Ljava/io/InputStream;)Lnet/minecraft/nbt/NBTTagCompound;"))
    private NBTTagCompound spongeReadPlayerData(InputStream inputStream) throws IOException {
        Instant creation = this.file == null ? Instant.now() : Files.readAttributes(this.file, BasicFileAttributes.class, new LinkOption[0]).creationTime().toInstant();
        NBTTagCompound compound = CompressedStreamTools.func_74796_a((InputStream)inputStream);
        Instant lastPlayed = Instant.now();
        if (compound.func_150297_b("bukkit", 10)) {
            NBTTagCompound bukkitCompound = compound.func_74775_l("bukkit");
            creation = Instant.ofEpochMilli(bukkitCompound.func_74763_f("firstPlayed"));
            lastPlayed = Instant.ofEpochMilli(bukkitCompound.func_74763_f("lastPlayed"));
        }
        UUID playerId = null;
        if (compound.func_186855_b("UUID")) {
            playerId = compound.func_186857_a("UUID");
        }
        if (playerId != null) {
            Optional<Instant> savedJoined;
            Optional<Instant> savedFirst = SpongePlayerDataHandler.getFirstJoined(playerId);
            if (savedFirst.isPresent()) {
                creation = savedFirst.get();
            }
            if ((savedJoined = SpongePlayerDataHandler.getLastPlayed(playerId)).isPresent()) {
                lastPlayed = savedJoined.get();
            }
            SpongePlayerDataHandler.setPlayerInfo(playerId, creation, lastPlayed);
        }
        this.file = null;
        return compound;
    }

    @Inject(method={"writePlayerData"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompressedStreamTools;writeCompressed(Lnet/minecraft/nbt/NBTTagCompound;Ljava/io/OutputStream;)V", shift=At.Shift.AFTER)})
    private void onSpongeWrite(EntityPlayer player, CallbackInfo callbackInfo) {
        SpongePlayerDataHandler.savePlayer(player.func_110124_au());
    }

    @Override
    public File getSpongeWorldDirectory() {
        return this.field_75770_b;
    }
}

