/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.entitycollisions;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.mixin.plugin.entitycollisions.interfaces.IModData_Collisions;

@Mixin(value={Chunk.class})
public class MixinChunk_Collisions {
    @Shadow
    @Final
    private World field_76637_e;

    @Inject(method={"getEntitiesWithinAABBForEntity"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", remap=false)}, cancellable=true)
    public void onAddCollisionEntity(Entity entityIn, AxisAlignedBB aabb, List<Entity> listToFill, Predicate<? super Entity> predicate, CallbackInfo ci) {
        if (this.field_76637_e.field_72995_K || entityIn == null || entityIn instanceof EntityPlayer || entityIn.func_70021_al() != null) {
            return;
        }
        if (!this.allowEntityCollision(listToFill)) {
            ci.cancel();
        }
    }

    @Inject(method={"getEntitiesOfTypeWithinAABB"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", remap=false)}, cancellable=true)
    public <T extends Entity> void onAddCollisionEntity(Class<? extends T> entityClass, AxisAlignedBB aabb, List<T> listToFill, Predicate<? super T> p_177430_4_, CallbackInfo ci) {
        if (this.field_76637_e.field_72995_K || EntityPlayer.class.isAssignableFrom(entityClass) || EntityItem.class == entityClass) {
            return;
        }
        if (!this.allowEntityCollision(listToFill)) {
            ci.cancel();
        }
    }

    private <T extends Entity> boolean allowEntityCollision(List<T> listToFill) {
        if (this.field_76637_e instanceof IMixinWorldServer) {
            IMixinWorldServer spongeWorld = (IMixinWorldServer)this.field_76637_e;
            if (spongeWorld.isProcessingExplosion()) {
                return true;
            }
            PhaseContext phaseContext = CauseTracker.getInstance().getCurrentContext();
            LocatableBlock locatable = phaseContext.getSource(LocatableBlock.class).orElse(null);
            if (locatable != null) {
                BlockType blockType = locatable.getLocation().getBlockType();
                IModData_Collisions spongeBlock = (IModData_Collisions)((Object)blockType);
                if (spongeBlock.requiresCollisionsCacheRefresh()) {
                    spongeBlock.initializeCollisionState(this.field_76637_e);
                    spongeBlock.requiresCollisionsCacheRefresh(false);
                }
                return spongeBlock.getMaxCollisions() < 0 || listToFill.size() < spongeBlock.getMaxCollisions();
            }
            IModData_Collisions spongeEntity = phaseContext.getSource(IModData_Collisions.class).orElse(null);
            if (spongeEntity != null) {
                if (spongeEntity.requiresCollisionsCacheRefresh()) {
                    spongeEntity.initializeCollisionState(this.field_76637_e);
                    spongeEntity.requiresCollisionsCacheRefresh(false);
                }
                return spongeEntity.getMaxCollisions() < 0 || listToFill.size() < spongeEntity.getMaxCollisions();
            }
            return true;
        }
        return true;
    }
}

