/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.registry.CatalogRegistryModule;

public abstract class AbstractPrefixCheckCatalogRegistryModule<T extends CatalogType>
implements CatalogRegistryModule<T> {
    protected final Map<String, T> catalogTypeMap = new ConcurrentHashMap<String, T>();
    protected final String defaultModIdToPrepend;

    protected AbstractPrefixCheckCatalogRegistryModule(String defaultModIdToPrepend) {
        this.defaultModIdToPrepend = defaultModIdToPrepend;
    }

    @Override
    public Optional<T> getById(String id) {
        String key = ((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH);
        if (!key.contains(":")) {
            key = this.defaultModIdToPrepend + ":" + key;
        }
        return Optional.ofNullable(this.catalogTypeMap.get(key));
    }

    @Override
    public Collection<T> getAll() {
        return Collections.unmodifiableCollection(this.catalogTypeMap.values());
    }

    protected void register(T catalog) {
        this.catalogTypeMap.put(catalog.getId(), catalog);
    }
}

