/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.world.schematic.BlockPaletteType;
import org.spongepowered.api.world.schematic.BlockPaletteTypes;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;
import org.spongepowered.common.world.schematic.BimapPalette;
import org.spongepowered.common.world.schematic.GlobalPalette;
import org.spongepowered.common.world.schematic.SpongePaletteType;

public class PaletteTypeRegistryModule
implements SpongeAdditionalCatalogRegistryModule<BlockPaletteType> {
    @RegisterCatalog(value=BlockPaletteTypes.class)
    private final Map<String, BlockPaletteType> paletteMappings = Maps.newHashMap();

    @Override
    public void registerAdditionalCatalog(BlockPaletteType extraCatalog) {
        Preconditions.checkNotNull((Object)extraCatalog);
        String id = extraCatalog.getId();
        Preconditions.checkArgument((id.indexOf(32) == -1 ? 1 : 0) != 0, (Object)("Palette Type ID " + id + " may not contain a space"));
        this.paletteMappings.put(id.toLowerCase(Locale.ENGLISH), extraCatalog);
    }

    @Override
    public Optional<BlockPaletteType> getById(String id) {
        return Optional.ofNullable(this.paletteMappings.get(id));
    }

    @Override
    public Collection<BlockPaletteType> getAll() {
        return ImmutableList.copyOf(this.paletteMappings.values());
    }

    @Override
    public void registerDefaults() {
        this.registerAdditionalCatalog(new SpongePaletteType("global", () -> GlobalPalette.instance));
        this.registerAdditionalCatalog(new SpongePaletteType("local", BimapPalette::new));
    }

    @Override
    public boolean allowsApiRegistration() {
        return true;
    }
}

