/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.graph;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;

public class DirectedGraph<D> {
    protected final List<DataNode<D>> nodes = Lists.newArrayList();

    public int getNodeCount() {
        return this.nodes.size();
    }

    public int getEdgeCount() {
        int count = 0;
        for (DataNode<D> n : this.nodes) {
            count += n.getEdgeCount();
        }
        return count;
    }

    public boolean contains(D data) {
        for (DataNode<D> node : this.nodes) {
            if (!node.data.equals(data)) continue;
            return true;
        }
        return false;
    }

    public DataNode<D> getNode(D data) {
        for (DataNode<D> node : this.nodes) {
            if (!node.data.equals(data)) continue;
            return node;
        }
        return null;
    }

    public void addEdge(D from, D to) {
        this.add(from);
        this.add(to);
        DataNode<D> fromNode = this.getNode(from);
        DataNode<D> toNode = this.getNode(to);
        this.addEdge(fromNode, toNode);
    }

    public void addEdge(DataNode<D> from, DataNode<D> to) {
        if (!this.nodes.contains(from)) {
            this.nodes.add(from);
        }
        if (!this.nodes.contains(to)) {
            this.nodes.add(to);
        }
        if (!from.isAdjacent(to)) {
            from.addEdge(to);
        }
    }

    public Iterable<DataNode<D>> getNodes() {
        return this.nodes;
    }

    public DirectedGraph<D> reverse() {
        DirectedGraph<D> rev = new DirectedGraph<D>();
        HashMap siblings = Maps.newHashMap();
        for (DataNode<D> n : this.nodes) {
            Object b = n.clone();
            siblings.put(n, b);
        }
        for (DataNode<D> n : this.nodes) {
            for (DataNode<D> b : n.getAdjacent()) {
                rev.addEdge((DataNode)siblings.get(b), (DataNode)siblings.get(n));
            }
        }
        return rev;
    }

    public DataNode<D> add(D d) {
        if (!this.contains(d)) {
            DataNode<D> node = new DataNode<D>(d);
            this.nodes.add(node);
        }
        return this.getNode(d);
    }

    public void add(DataNode<D> n) {
        if (!this.contains(n.data)) {
            this.nodes.add(n);
        }
    }

    public void delete(D n) {
        DataNode<D> node = null;
        for (DataNode<D> node1 : this.nodes) {
            if (!node1.data.equals(n)) continue;
            node = node1;
            break;
        }
        if (node != null) {
            this.delete(node);
        }
    }

    public void delete(DataNode<D> n) {
        for (DataNode<D> b : this.nodes) {
            b.deleteEdge(n);
        }
        this.nodes.remove(n);
    }

    public String toString() {
        String s = this.getNodeCount() + "\n" + this.getEdgeCount() + "\n";
        for (DataNode<D> n : this.nodes) {
            s = s + n.getData().toString() + " ";
            for (DataNode<D> a : n.getAdjacent()) {
                s = s + this.nodes.indexOf(a) + " ";
            }
            s = s + "\n";
        }
        return s;
    }

    public static class DataNode<D> {
        private final List<DataNode<D>> adj = Lists.newArrayList();
        final D data;

        public DataNode(D obj) {
            this.data = obj;
        }

        public D getData() {
            return this.data;
        }

        public void addEdge(DataNode<D> other) {
            this.adj.add(other);
        }

        public void deleteEdge(DataNode<D> other) {
            this.adj.remove(other);
        }

        public boolean isAdjacent(DataNode<D> other) {
            return this.adj.contains(other);
        }

        public int getEdgeCount() {
            return this.adj.size();
        }

        public Iterable<DataNode<D>> getAdjacent() {
            return this.adj;
        }

        public DataNode<D> clone() {
            return new DataNode<D>(this.data);
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataNode)) {
                return false;
            }
            DataNode d = (DataNode)o;
            return d.getData().equals(this.data);
        }
    }
}

