/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.processor;

import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.Listener;
import org.spongepowered.plugin.processor.ProcessorUtils;

@SupportedAnnotationTypes(value={"org.spongepowered.api.event.Listener"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ListenerProcessor
extends AbstractProcessor {
    static final String LISTENER_ANNOTATION_CLASS = "org.spongepowered.api.event.Listener";
    private static final String EVENT_CLASS = Event.class.getName();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (ProcessorUtils.contains(annotations, Listener.class)) {
            for (Element element : roundEnv.getElementsAnnotatedWith(Listener.class)) {
                List<? extends VariableElement> parameters;
                if (element.getKind() != ElementKind.METHOD) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Invalid element of type " + (Object)((Object)element.getKind()) + " annotated with @Listener", element);
                    continue;
                }
                ExecutableElement method = (ExecutableElement)element;
                Messager msg = this.processingEnv.getMessager();
                if (method.getModifiers().contains((Object)Modifier.STATIC)) {
                    msg.printMessage(Diagnostic.Kind.ERROR, "method must not be static", method);
                }
                if (!method.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    msg.printMessage(Diagnostic.Kind.ERROR, "method must be public", method);
                }
                if (method.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    msg.printMessage(Diagnostic.Kind.ERROR, "method must not be abstract", method);
                }
                if (method.getEnclosingElement().getKind().isInterface()) {
                    msg.printMessage(Diagnostic.Kind.ERROR, "interfaces cannot declare listeners", method);
                }
                if (method.getReturnType().getKind() != TypeKind.VOID) {
                    msg.printMessage(Diagnostic.Kind.ERROR, "method must return void", method);
                }
                if (!(parameters = method.getParameters()).isEmpty() && this.isTypeSubclass(parameters.get(0), EVENT_CLASS)) continue;
                msg.printMessage(Diagnostic.Kind.ERROR, "method must have an Event as its first parameter", method);
            }
        }
        return false;
    }

    private boolean isTypeSubclass(Element typedElement, String subclass) {
        Elements elements = this.processingEnv.getElementUtils();
        Types types = this.processingEnv.getTypeUtils();
        DeclaredType event = types.getDeclaredType(elements.getTypeElement(subclass), new TypeMirror[0]);
        return types.isAssignable(typedElement.asType(), event);
    }
}

