/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.processor;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import javax.annotation.processing.Messager;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.spongepowered.api.plugin.Dependency;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.plugin.meta.PluginDependency;
import org.spongepowered.plugin.meta.PluginMetadata;
import org.spongepowered.plugin.meta.version.InvalidVersionSpecificationException;
import org.spongepowered.plugin.meta.version.VersionRange;
import org.spongepowered.plugin.processor.AnnotationWrapper;

final class PluginElement {
    private static final String API_VERSION = PluginElement.class.getPackage().getSpecificationVersion();
    private final TypeElement element;
    private final AnnotationWrapper<Plugin> annotation;
    private final PluginMetadata metadata;

    PluginElement(TypeElement element, AnnotationWrapper<Plugin> annotation, PluginMetadata metadata) {
        this.element = (TypeElement)Preconditions.checkNotNull((Object)element, (Object)"element");
        this.annotation = (AnnotationWrapper)Preconditions.checkNotNull(annotation, (Object)"annotation");
        this.metadata = metadata;
    }

    TypeElement getElement() {
        return this.element;
    }

    AnnotationWrapper<Plugin> getAnnotation() {
        return this.annotation;
    }

    PluginMetadata getMetadata() {
        return this.metadata;
    }

    void apply(Messager messager) {
        String value = this.annotation.get().id();
        if (!Plugin.ID_PATTERN.matcher(value).matches()) {
            messager.printMessage(Diagnostic.Kind.ERROR, "Plugin ID '" + value + "' must match pattern '" + Plugin.ID_PATTERN.pattern() + "'. It should be lower case, start with an alphabetic character and may only contain alphanumeric characters, underscores or dashes.", this.element, this.annotation.getMirror(), this.annotation.getValue("id"));
        }
        if ((value = this.annotation.get().name()).isEmpty()) {
            if (this.metadata.getName() == null) {
                messager.printMessage(Diagnostic.Kind.WARNING, "Missing plugin name", this.element, this.annotation.getMirror());
            }
        } else {
            this.metadata.setName(value);
        }
        if ((value = this.annotation.get().version()).isEmpty()) {
            if (this.metadata.getVersion() == null) {
                messager.printMessage(Diagnostic.Kind.WARNING, "Missing plugin version", this.element, this.annotation.getMirror());
            }
        } else {
            this.metadata.setVersion(value);
        }
        if ((value = this.annotation.get().description()).isEmpty()) {
            if (this.metadata.getDescription() == null) {
                messager.printMessage(Diagnostic.Kind.WARNING, "Missing plugin description", this.element, this.annotation.getMirror());
            }
        } else {
            this.metadata.setDescription(value);
        }
        if (!(value = this.annotation.get().url()).isEmpty()) {
            if (!PluginElement.isLikelyValidUrl(value)) {
                messager.printMessage(Diagnostic.Kind.ERROR, "Invalid URL: " + value, this.element, this.annotation.getMirror(), this.annotation.getValue("url"));
            }
            this.metadata.setUrl(value);
        } else {
            value = this.metadata.getUrl();
            if (value != null && !PluginElement.isLikelyValidUrl(value)) {
                messager.printMessage(Diagnostic.Kind.ERROR, "Invalid URL: " + value + " in extra metadata files", this.element, this.annotation.getMirror());
            }
        }
        String[] authors = this.annotation.get().authors();
        if (authors.length > 0) {
            this.metadata.getAuthors().clear();
            for (String author : authors) {
                if (author.isEmpty()) {
                    messager.printMessage(Diagnostic.Kind.ERROR, "Empty author is not allowed", this.element, this.annotation.getMirror(), this.annotation.getValue("authors"));
                    continue;
                }
                this.metadata.addAuthor(author);
            }
        }
        this.checkDependencies(this.metadata.getDependencies(), messager);
        HashSet<String> addedDependencies = new HashSet<String>();
        Dependency[] dependencies = this.annotation.get().dependencies();
        if (dependencies.length > 0) {
            for (Dependency dependency : dependencies) {
                String id = dependency.id();
                if (id.isEmpty()) {
                    messager.printMessage(Diagnostic.Kind.ERROR, "Dependency ID should not be empty", this.element, this.annotation.getMirror(), this.annotation.getValue("dependencies"));
                    continue;
                }
                if (id.equals("*")) {
                    messager.printMessage(Diagnostic.Kind.ERROR, "Wildcard dependencies are not supported on Sponge", this.element, this.annotation.getMirror(), this.annotation.getValue("dependencies"));
                    continue;
                }
                String version = dependency.version();
                if (!version.isEmpty()) {
                    try {
                        VersionRange.createFromVersionSpec(version);
                    }
                    catch (InvalidVersionSpecificationException e) {
                        messager.printMessage(Diagnostic.Kind.ERROR, "Invalid dependency version range: " + version + " (" + e.getMessage() + ") Please check the Javadocs of @Dependency.version() for details.", this.element, this.annotation.getMirror(), this.annotation.getValue("dependencies"));
                    }
                }
                if (addedDependencies.add(id)) {
                    this.metadata.replaceDependency(new PluginDependency(PluginDependency.LoadOrder.BEFORE, id, dependency.version(), dependency.optional()));
                    continue;
                }
                messager.printMessage(Diagnostic.Kind.ERROR, "Duplicate dependency with plugin ID: " + id, this.element, this.annotation.getMirror(), this.annotation.getValue("dependencies"));
            }
        }
        if (this.metadata.getDependency("spongeapi") == null) {
            this.metadata.addDependency(new PluginDependency(PluginDependency.LoadOrder.BEFORE, "spongeapi", API_VERSION, false));
        }
    }

    private void checkDependencies(Iterable<PluginDependency> dependencies, Messager messager) {
        for (PluginDependency dependency : dependencies) {
            if (dependency.getId().isEmpty()) {
                messager.printMessage(Diagnostic.Kind.ERROR, "Dependency from extra metadata file cannot have an empty plugin ID", this.element, this.annotation.getMirror());
                continue;
            }
            if (dependency.getId().equals("*")) {
                messager.printMessage(Diagnostic.Kind.ERROR, "Wildcard dependency from extra metadata file is not supported on Sponge", this.element, this.annotation.getMirror());
                continue;
            }
            String version = dependency.getVersion();
            if (version == null) continue;
            try {
                VersionRange.createFromVersionSpec(version);
            }
            catch (InvalidVersionSpecificationException e) {
                messager.printMessage(Diagnostic.Kind.ERROR, "Invalid dependency version range from extra metadata file: " + version + " (" + e.getMessage() + ") Please check the Javadocs of @Dependency.version() for details.", this.element, this.annotation.getMirror());
            }
        }
    }

    private static boolean isLikelyValidUrl(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (MalformedURLException | URISyntaxException ignored) {
            return false;
        }
    }
}

