/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch.transformer.deobf.mappings;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.spongepowered.server.launch.transformer.deobf.mappings.ClassMappings;
import org.spongepowered.server.launch.transformer.deobf.mappings.MemberDescriptor;

public final class CompactMappingsReader {
    private static final String SEPARATOR = " ";
    private static final char CLASS_COUNT_IDENTIFIER = 't';
    private static final char CLASS_IDENTIFIER = 'c';
    private static final char FIELD_IDENTIFIER = 'f';
    private static final char METHOD_IDENTIFIER = 'm';
    private static final char COMMENT_IDENTIFIER = '#';
    private final ImmutableMap.Builder<String, ClassMappings> mappings = ImmutableMap.builder();
    private final ImmutableMap.Builder<String, String> reverseClasses = ImmutableMap.builder();

    public void read(URL resource) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8));){
            this.read(reader);
        }
    }

    public void read(BufferedReader reader) throws IOException {
        String line;
        String currentClass = null;
        String currentMappedName = null;
        ImmutableMap.Builder currentFields = null;
        ImmutableMap.Builder currentMethods = null;
        block6: while ((line = reader.readLine()) != null) {
            char identifier;
            if ((line = line.trim()).length() < 3 || (identifier = line.charAt(0)) == '#') continue;
            String[] args = line.substring(2).split(SEPARATOR);
            switch (line.charAt(0)) {
                case 'c': {
                    if (currentClass != null) {
                        this.mappings.put((Object)currentClass, (Object)new ClassMappings(currentMappedName, (ImmutableMap<MemberDescriptor, String>)currentFields.build(), (ImmutableMap<MemberDescriptor, String>)currentMethods.build()));
                    }
                    if (!(currentClass = args[0]).equals(currentMappedName = args[1])) {
                        this.reverseClasses.put((Object)currentMappedName, (Object)currentClass);
                    }
                    currentFields = ImmutableMap.builder();
                    currentMethods = ImmutableMap.builder();
                    continue block6;
                }
                case 'f': {
                    if (currentClass == null) {
                        throw new IllegalStateException("Field mapping without a class");
                    }
                    currentFields.put((Object)new MemberDescriptor(args[0], args[1]), (Object)args[2]);
                    continue block6;
                }
                case 'm': {
                    if (currentClass == null) {
                        throw new IllegalStateException("Method mapping without a class");
                    }
                    currentMethods.put((Object)new MemberDescriptor(args[0], args[1]), (Object)args[2]);
                    continue block6;
                }
                case 't': {
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Invalid line: " + line);
        }
        if (currentClass != null) {
            this.mappings.put(currentClass, (Object)new ClassMappings(currentMappedName, (ImmutableMap<MemberDescriptor, String>)currentFields.build(), (ImmutableMap<MemberDescriptor, String>)currentMethods.build()));
        }
    }

    public ImmutableMap<String, ClassMappings> getMappings() {
        return this.mappings.build();
    }

    public ImmutableMap<String, String> getReverseClasses() {
        return this.reverseClasses.build();
    }
}

