/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.mixin.core.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.CombatTracker;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.UseItemStackEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

@Mixin(value={EntityLivingBase.class})
public abstract class MixinEntityLivingBase
extends Entity {
    @Shadow
    @Nullable
    protected ItemStack field_184627_bm;
    @Shadow
    protected int field_184628_bn;

    @Shadow
    public abstract CombatTracker func_110142_aN();

    @Shadow
    public abstract void func_184611_a(EnumHand var1, @Nullable ItemStack var2);

    @Shadow
    public abstract int func_184605_cv();

    @Shadow
    public abstract void func_184602_cy();

    protected MixinEntityLivingBase(World world) {
        super(world);
    }

    @Inject(method={"setActiveHand"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="FIELD", target="Lnet/minecraft/entity/EntityLivingBase;activeItemStack:Lnet/minecraft/item/ItemStack;")})
    private void onSetActiveItemStack(EnumHand hand, CallbackInfo ci, ItemStack stack) {
        Sponge.getCauseStackManager().pushCause((Object)this);
        UseItemStackEvent.Start event = SpongeEventFactory.createUseItemStackEventStart(Sponge.getCauseStackManager().getCurrentCause(), stack.func_77988_m(), stack.func_77988_m(), ItemStackUtil.snapshotOf(stack));
        if (SpongeImpl.postEvent(event)) {
            ci.cancel();
        } else {
            this.field_184628_bn = event.getRemainingDuration();
        }
        Sponge.getCauseStackManager().popCause();
    }

    @Redirect(method={"setActiveHand"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getMaxItemUseDuration()I"))
    private int getItemDuration(ItemStack stack) {
        return this.field_184628_bn;
    }

    @Redirect(method={"updateActiveHand"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;getItemInUseCount()I", ordinal=0))
    private int onGetRemainingItemDuration(EntityLivingBase self) {
        Sponge.getCauseStackManager().pushCause((Object)this);
        UseItemStackEvent.Tick event = SpongeEventFactory.createUseItemStackEventTick(Sponge.getCauseStackManager().getCurrentCause(), this.field_184628_bn, this.field_184628_bn, ItemStackUtil.snapshotOf(this.field_184627_bm));
        SpongeImpl.postEvent(event);
        Sponge.getCauseStackManager().popCause();
        this.field_184628_bn = Math.max(event.getRemainingDuration(), 1);
        if (event.isCancelled()) {
            return 26;
        }
        return this.func_184605_cv();
    }

    @Inject(method={"onItemUseFinish"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;updateItemUse(Lnet/minecraft/item/ItemStack;I)V")})
    private void onUpdateItemUse(CallbackInfo ci) {
        Sponge.getCauseStackManager().pushCause((Object)this);
        UseItemStackEvent.Finish event = SpongeEventFactory.createUseItemStackEventFinish(Sponge.getCauseStackManager().getCurrentCause(), this.field_184628_bn, this.field_184628_bn, ItemStackUtil.snapshotOf(this.field_184627_bm));
        SpongeImpl.postEvent(event);
        Sponge.getCauseStackManager().popCause();
        if (event.getRemainingDuration() > 0) {
            this.field_184628_bn = event.getRemainingDuration();
            ci.cancel();
        } else if (event.isCancelled()) {
            this.func_184602_cy();
            ci.cancel();
        }
    }

    @Redirect(method={"onItemUseFinish"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;setHeldItem(Lnet/minecraft/util/EnumHand;Lnet/minecraft/item/ItemStack;)V"))
    private void onSetHeldItem(EntityLivingBase self, EnumHand hand, @Nullable ItemStack stack) {
        ItemStackSnapshot activeItemStackSnapshot = ItemStackUtil.snapshotOf(this.field_184627_bm);
        Sponge.getCauseStackManager().pushCause((Object)this);
        UseItemStackEvent.Replace event = SpongeEventFactory.createUseItemStackEventReplace(Sponge.getCauseStackManager().getCurrentCause(), this.field_184628_bn, this.field_184628_bn, activeItemStackSnapshot, new Transaction<ItemStackSnapshot>(activeItemStackSnapshot, ItemStackUtil.snapshotOf(stack)));
        if (SpongeImpl.postEvent(event)) {
            Sponge.getCauseStackManager().popCause();
            return;
        }
        Sponge.getCauseStackManager().popCause();
        if (!event.getItemStackResult().isValid()) {
            return;
        }
        this.func_184611_a(hand, ItemStackUtil.fromSnapshotToNative(event.getItemStackResult().getFinal()));
    }

    @Redirect(method={"stopActiveHand"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;onPlayerStoppedUsing(Lnet/minecraft/world/World;Lnet/minecraft/entity/EntityLivingBase;I)V"))
    private void onStopPlayerUsing(ItemStack stack, World world, EntityLivingBase self, int duration) {
        Sponge.getCauseStackManager().pushCause((Object)this);
        if (!SpongeImpl.postEvent(SpongeEventFactory.createUseItemStackEventStop(Sponge.getCauseStackManager().getCurrentCause(), duration, duration, ItemStackUtil.snapshotOf(stack)))) {
            stack.func_77974_b(world, self, duration);
        }
        Sponge.getCauseStackManager().popCause();
    }

    @Inject(method={"resetActiveHand"}, at={@At(value="HEAD")})
    private void onResetActiveHand(CallbackInfo ci) {
        Sponge.getCauseStackManager().pushCause((Object)this);
        SpongeImpl.postEvent(SpongeEventFactory.createUseItemStackEventReset(Sponge.getCauseStackManager().getCurrentCause(), this.field_184628_bn, this.field_184628_bn, ItemStackUtil.snapshotOf(this.field_184627_bm)));
        Sponge.getCauseStackManager().popCause();
    }
}

