/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.mixin.core.world;

import net.minecraft.network.Packet;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.management.PlayerList;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.interfaces.world.IMixinWorldInfo;
import org.spongepowered.common.world.WorldManager;

@Mixin(value={WorldServer.class})
public abstract class MixinWorldServer
extends World {
    private MixinWorldServer(ISaveHandler saveHandlerIn, WorldInfo info, WorldProvider providerIn, Profiler profilerIn, boolean client) {
        super(saveHandlerIn, info, providerIn, profilerIn, client);
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/DimensionType;getById(I)Lnet/minecraft/world/DimensionType;"))
    private static DimensionType getDimensionType(int dimensionId) {
        return WorldManager.getDimensionType(dimensionId).orElseThrow(() -> new IllegalArgumentException("Invalid dimension id: " + dimensionId));
    }

    @Redirect(method={"updateWeather"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/DimensionType;getId()I"))
    private int onGetDimensionIdForWeather(DimensionType type) {
        return this.getDimensionId();
    }

    @Redirect(method={"updateWeather"}, require=4, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V"))
    private void onSendWeatherPacket(PlayerList manager, Packet<?> packet) {
        manager.func_148537_a(packet, this.getDimensionId().intValue());
    }

    public Integer getDimensionId() {
        return ((IMixinWorldInfo)this.field_72986_A).getDimensionId();
    }

    public void setDimensionId(int dimensionId) {
        ((IMixinWorldInfo)this.field_72986_A).setDimensionId(dimensionId);
    }
}

