/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.network;

import com.google.common.collect.Sets;
import io.netty.buffer.Unpooled;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketCustomPayload;
import org.spongepowered.api.Platform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.network.ChannelBinding;
import org.spongepowered.api.network.ChannelBuf;
import org.spongepowered.api.network.ChannelRegistrar;
import org.spongepowered.api.network.RawDataListener;
import org.spongepowered.api.network.RemoteConnection;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.server.interfaces.IMixinNetHandlerPlayServer;
import org.spongepowered.server.network.VanillaChannelBinding;

public final class VanillaRawDataChannel
extends VanillaChannelBinding
implements ChannelBinding.RawDataChannel {
    private final Set<RawDataListener> listeners = Sets.newIdentityHashSet();

    public VanillaRawDataChannel(ChannelRegistrar registrar, String name, PluginContainer owner) {
        super(registrar, name, owner);
    }

    @Override
    public void addListener(RawDataListener listener) {
        this.validate();
        this.listeners.add(listener);
    }

    @Override
    public void addListener(Platform.Type side, RawDataListener listener) {
        if (side == Platform.Type.SERVER) {
            this.addListener(listener);
        }
    }

    @Override
    public void removeListener(RawDataListener listener) {
        this.validate();
        this.listeners.remove(listener);
    }

    @Override
    public void post(RemoteConnection connection, PacketBuffer payload) {
        ChannelBuf buf = (ChannelBuf)payload;
        for (RawDataListener listener : this.listeners) {
            try {
                listener.handlePayload(buf, connection, Platform.Type.SERVER);
            }
            catch (Throwable e) {
                this.getOwner().getLogger().error("Could not pass payload on channel '{}' to {}", this.getName(), this.getOwner(), e);
            }
        }
    }

    private SPacketCustomPayload createPacket(Consumer<ChannelBuf> consumer) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        consumer.accept((ChannelBuf)buffer);
        return new SPacketCustomPayload(this.getName(), buffer);
    }

    @Override
    public void sendTo(Player player, Consumer<ChannelBuf> payload) {
        this.validate();
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        if (((IMixinNetHandlerPlayServer)playerMP.field_71135_a).supportsChannel(this.getName())) {
            playerMP.field_71135_a.func_147359_a((Packet)this.createPacket(payload));
        }
    }

    @Override
    public void sendToServer(Consumer<ChannelBuf> payload) {
        this.validate();
    }

    @Override
    public void sendToAll(Consumer<ChannelBuf> payload) {
        this.validate();
        String name = this.getName();
        SPacketCustomPayload packet = null;
        for (EntityPlayerMP player : SpongeImpl.getServer().func_184103_al().func_181057_v()) {
            if (!((IMixinNetHandlerPlayServer)player.field_71135_a).supportsChannel(name)) continue;
            if (packet == null) {
                packet = this.createPacket(payload);
            }
            player.field_71135_a.func_147359_a((Packet)packet);
        }
    }
}

