/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.plugin;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.plugin.meta.McModInfo;
import org.spongepowered.plugin.meta.PluginMetadata;
import org.spongepowered.server.launch.LaunchException;
import org.spongepowered.server.launch.VanillaLaunch;
import org.spongepowered.server.plugin.MetaPluginContainer;

public final class MetadataContainer {
    private final ImmutableMap<String, PluginMetadata> metadata;

    private MetadataContainer(ImmutableMap<String, PluginMetadata> metadata) {
        this.metadata = metadata;
    }

    public boolean isEmpty() {
        return this.metadata.isEmpty();
    }

    public PluginMetadata get(String id, String name) {
        PluginMetadata meta = (PluginMetadata)this.metadata.get((Object)id);
        if (meta == null) {
            if (VanillaLaunch.ENVIRONMENT != VanillaLaunch.Environment.DEVELOPMENT) {
                throw new RuntimeException("Unable to find metadata for " + id);
            }
            meta = new PluginMetadata(id);
            meta.setName(name);
        }
        return meta;
    }

    PluginContainer createContainer(String id, String name, Optional<Path> source) {
        return new MetaPluginContainer(this.get(id, name), source);
    }

    public static MetadataContainer load() {
        return MetadataContainer.load("");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MetadataContainer load(String path) {
        List<PluginMetadata> meta;
        Object object;
        path = path + '/' + "mcmod.info";
        try {
            InputStream in = MetadataContainer.class.getResourceAsStream(path);
            object = null;
            try {
                if (in == null) {
                    if (VanillaLaunch.ENVIRONMENT != VanillaLaunch.Environment.DEVELOPMENT) {
                        throw new LaunchException("Unable to find metadata file at " + path);
                    }
                    MetadataContainer metadataContainer = new MetadataContainer((ImmutableMap<String, PluginMetadata>)ImmutableMap.of());
                    return metadataContainer;
                }
                meta = McModInfo.DEFAULT.read(in);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (in != null) {
                    if (object != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new LaunchException("Failed to load metadata", e);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        object = meta.iterator();
        while (object.hasNext()) {
            PluginMetadata m = (PluginMetadata)object.next();
            builder.put((Object)m.getId(), (Object)m);
        }
        return new MetadataContainer((ImmutableMap<String, PluginMetadata>)builder.build());
    }
}

