/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.atlas;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.cadixdev.atlas.AtlasTransformerContext;
import org.cadixdev.atlas.jar.JarFile;
import org.cadixdev.atlas.util.CascadingClassProvider;
import org.cadixdev.bombe.asm.analysis.ClassProviderInheritanceProvider;
import org.cadixdev.bombe.asm.jar.ClassProvider;
import org.cadixdev.bombe.jar.JarEntryTransformer;

public class Atlas
implements Closeable {
    private final List<Function<AtlasTransformerContext, JarEntryTransformer>> transformers = new ArrayList<Function<AtlasTransformerContext, JarEntryTransformer>>();
    private final List<JarFile> classpath = new ArrayList<JarFile>();

    public Atlas use(Path jar) throws IOException {
        this.classpath.add(new JarFile(jar));
        return this;
    }

    public Atlas install(Function<AtlasTransformerContext, JarEntryTransformer> transformer) {
        this.transformers.add(transformer);
        return this;
    }

    public void run(Path input, Path output) throws IOException {
        try (JarFile jar = new JarFile(input);){
            this.run(jar, output);
        }
    }

    public void run(JarFile jar, Path output) throws IOException {
        ArrayList<ClassProvider> classpath = new ArrayList<ClassProvider>();
        classpath.add(jar);
        classpath.addAll(this.classpath);
        AtlasTransformerContext context = new AtlasTransformerContext(new ClassProviderInheritanceProvider(new CascadingClassProvider(classpath)));
        JarEntryTransformer[] transformers = (JarEntryTransformer[])this.transformers.stream().map(constructor -> (JarEntryTransformer)constructor.apply(context)).toArray(JarEntryTransformer[]::new);
        jar.transform(output, transformers);
    }

    @Override
    public void close() throws IOException {
        for (JarFile jar : this.classpath) {
            jar.close();
        }
        this.classpath.clear();
    }
}

