/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.bombe.jar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.jar.Manifest;
import org.cadixdev.bombe.jar.AbstractJarEntry;
import org.cadixdev.bombe.jar.JarEntryTransformer;

public class JarManifestEntry
extends AbstractJarEntry {
    private static final String NAME = "META-INF/MANIFEST.MF";
    private static final String EXTENSION = "MF";
    private final Manifest manifest;

    public JarManifestEntry(long time, Manifest manifest) {
        super(NAME, time);
        this.manifest = manifest;
    }

    public final Manifest getManifest() {
        return this.manifest;
    }

    @Override
    public final String getExtension() {
        return EXTENSION;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final byte[] getContents() {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            this.manifest.write(baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ignored) {
            return null;
        }
    }

    @Override
    public JarManifestEntry accept(JarEntryTransformer vistor) {
        return vistor.transform(this);
    }
}

