/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.bombe.type;

import java.util.Arrays;
import java.util.Objects;
import org.cadixdev.bombe.type.FieldType;

public class ArrayType
implements FieldType {
    private final int dimCount;
    private final String arrayDims;
    private final FieldType component;
    private final String descriptor;

    public ArrayType(int arrayDims, FieldType component) {
        this.dimCount = arrayDims;
        char[] dims = new char[arrayDims];
        Arrays.fill(dims, '[');
        this.arrayDims = new String(dims);
        this.component = component;
        this.descriptor = this.arrayDims + component.toString();
    }

    public int getDimCount() {
        return this.dimCount;
    }

    public String getDims() {
        return this.arrayDims;
    }

    public FieldType getComponent() {
        return this.component;
    }

    public String toString() {
        return this.descriptor;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArrayType)) {
            return false;
        }
        ArrayType that = (ArrayType)obj;
        return Objects.equals(this.dimCount, that.dimCount) && Objects.equals(this.component, that.component);
    }

    public int hashCode() {
        return Objects.hash(this.dimCount, this.component);
    }
}

