/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.bombe.type;

import java.util.Objects;
import java.util.Optional;
import org.cadixdev.bombe.analysis.InheritanceProvider;
import org.cadixdev.bombe.type.FieldType;
import org.cadixdev.bombe.type.Type;

public class ObjectType
implements FieldType {
    private final String className;
    private final String descriptor;

    public ObjectType(String className) {
        this.className = className.replace('.', '/');
        this.descriptor = "L" + this.className + ";";
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean isAssignableFrom(Type obj, InheritanceProvider inheritanceProvider) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectType)) {
            return false;
        }
        ObjectType that = (ObjectType)obj;
        if (this.equals(that) || this.className.equals("java/lang/Object")) {
            return true;
        }
        Optional<InheritanceProvider.ClassInfo> info = inheritanceProvider.provide(that.getClassName());
        return info.isPresent() && info.get().hasParent(this.className, inheritanceProvider);
    }

    public String toString() {
        return this.descriptor;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectType)) {
            return false;
        }
        ObjectType that = (ObjectType)obj;
        return Objects.equals(this.className, that.className);
    }

    public int hashCode() {
        return Objects.hash(this.className);
    }
}

