/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.lorenz.merge;

import java.util.Objects;
import org.cadixdev.lorenz.merge.FieldMergeStrategy;
import org.cadixdev.lorenz.merge.MappingSetMergerHandler;
import org.cadixdev.lorenz.merge.MethodMergeStrategy;

public final class MergeConfig {
    private final MappingSetMergerHandler handler;
    private final MethodMergeStrategy methodMergeStrategy;
    private final FieldMergeStrategy fieldMergeStrategy;

    MergeConfig(MappingSetMergerHandler handler, MethodMergeStrategy methodMergeStrategy, FieldMergeStrategy fieldMergeStrategy) {
        this.handler = Objects.requireNonNull(handler, "handler must not be null");
        this.methodMergeStrategy = Objects.requireNonNull(methodMergeStrategy, "methodMergeStrategy must not be null");
        this.fieldMergeStrategy = Objects.requireNonNull(fieldMergeStrategy, "fieldMergeStrategy must not be null");
    }

    public MappingSetMergerHandler getHandler() {
        return this.handler;
    }

    public MethodMergeStrategy getMethodMergeStrategy() {
        return this.methodMergeStrategy;
    }

    public FieldMergeStrategy getFieldMergeStrategy() {
        return this.fieldMergeStrategy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "MergeConfig{handler=" + this.handler + ", methodMergeStrategy=" + (Object)((Object)this.methodMergeStrategy) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergeConfig config = (MergeConfig)o;
        return Objects.equals(this.handler, config.handler) && this.methodMergeStrategy == config.methodMergeStrategy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.handler, this.methodMergeStrategy});
    }

    public static final class Builder {
        private MappingSetMergerHandler handler = new MappingSetMergerHandler(){};
        private MethodMergeStrategy methodMergeStrategy = MethodMergeStrategy.STRICT;
        private FieldMergeStrategy fieldMergeStrategy = FieldMergeStrategy.LOOSE;

        Builder() {
        }

        public Builder withMergeHandler(MappingSetMergerHandler handler) {
            this.handler = Objects.requireNonNull(handler);
            return this;
        }

        public Builder withMethodMergeStrategy(MethodMergeStrategy methodMergeStrategy) {
            this.methodMergeStrategy = Objects.requireNonNull(methodMergeStrategy);
            return this;
        }

        public Builder withFieldMergeStrategy(FieldMergeStrategy fieldMergeStrategy) {
            this.fieldMergeStrategy = Objects.requireNonNull(fieldMergeStrategy);
            return this;
        }

        public MergeConfig build() {
            return new MergeConfig(this.handler, this.methodMergeStrategy, this.fieldMergeStrategy);
        }
    }
}

