/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.advancement;

import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.advancement.AdvancementType;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.CopyableBuilder;

public interface DisplayInfo {
    public static Builder builder() {
        return Sponge.getRegistry().getBuilderRegistry().provideBuilder(Builder.class);
    }

    public AdvancementType getType();

    public Component getDescription();

    public ItemStackSnapshot getIcon();

    public Component getTitle();

    public boolean doesShowToast();

    public boolean doesAnnounceToChat();

    public boolean isHidden();

    public static interface Builder
    extends CopyableBuilder<DisplayInfo, Builder> {
        default public Builder type(Supplier<? extends AdvancementType> advancementType) {
            return this.type(advancementType.get());
        }

        public Builder type(AdvancementType var1);

        public Builder description(Component var1);

        public Builder title(Component var1);

        default public Builder icon(Supplier<? extends ItemType> itemType) {
            return this.icon(itemType.get());
        }

        default public Builder icon(ItemType itemType) {
            return this.icon(ItemStack.of(itemType, 1));
        }

        default public Builder icon(ItemStack itemStack) {
            return this.icon(itemStack.createSnapshot());
        }

        public Builder icon(ItemStackSnapshot var1);

        public Builder showToast(boolean var1);

        public Builder announceToChat(boolean var1);

        public Builder hidden(boolean var1);

        public DisplayInfo build();
    }
}

