/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.persistence.Queries;

public class Transaction<T extends DataSerializable>
implements DataSerializable {
    private final T original;
    private final T defaultReplacement;
    private boolean valid = true;
    private final @Nullable List<T> intermediary;
    private @Nullable T custom;

    public Transaction(T original, T defaultReplacement) {
        this.original = (DataSerializable)Objects.requireNonNull(original);
        this.defaultReplacement = (DataSerializable)Objects.requireNonNull(defaultReplacement);
        this.intermediary = null;
    }

    public Transaction(T original, T defaultReplacement, @Nullable List<? extends T> intermediary) {
        this.original = (DataSerializable)Objects.requireNonNull(original, "Original cannot be null");
        this.defaultReplacement = (DataSerializable)Objects.requireNonNull(defaultReplacement, "Default replacement cannot be null");
        this.intermediary = intermediary == null ? null : Collections.unmodifiableList(intermediary);
    }

    public final T getOriginal() {
        return this.original;
    }

    public final T getDefault() {
        return this.defaultReplacement;
    }

    public final List<? extends T> getIntermediary() {
        return this.intermediary == null ? Collections.emptyList() : this.intermediary;
    }

    public final Optional<T> getCustom() {
        return Optional.ofNullable(this.custom);
    }

    public final void setCustom(@Nullable T custom) {
        this.custom = custom;
    }

    public final T getFinal() {
        return this.custom == null ? this.defaultReplacement : this.custom;
    }

    public final boolean isValid() {
        return this.valid;
    }

    public final void setValid(boolean valid) {
        this.valid = valid;
    }

    public final void validate() {
        this.valid = true;
    }

    public final void invalidate() {
        this.valid = false;
    }

    public int hashCode() {
        return Objects.hash(this.original, this.defaultReplacement, this.valid, this.custom);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Transaction other = (Transaction)obj;
        return Objects.equals(this.original, other.original) && Objects.equals(this.defaultReplacement, other.defaultReplacement) && Objects.equals(this.valid, other.valid) && Objects.equals(this.custom, other.custom);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("original", this.original).add("default", this.defaultReplacement).add("custom", this.custom).add("valid", this.valid).toString();
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, this.getContentVersion()).set(Queries.TYPE_CLASS, this.original.getClass().getName()).set(Queries.ORIGINAL, this.original).set(Queries.DEFAULT_REPLACEMENT, this.defaultReplacement).set(Queries.VALID, this.valid);
        if (this.custom != null) {
            container.set(Queries.CUSTOM_REPLACEMENT, this.custom);
        }
        return container;
    }
}

