/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKey;

public interface CauseStackManager {
    public Cause getCurrentCause();

    public EventContext getCurrentContext();

    public CauseStackManager pushCause(Object var1);

    public Object popCause();

    public void popCauses(int var1);

    public Object peekCause();

    public StackFrame pushCauseFrame();

    public void popCauseFrame(StackFrame var1);

    public <T> CauseStackManager addContext(EventContextKey<T> var1, T var2);

    default public <T> CauseStackManager addContext(EventContextKey<T> key, Supplier<? extends T> value) {
        return this.addContext(key, value.get());
    }

    default public <T> CauseStackManager addContext(Supplier<? extends EventContextKey<T>> key, T value) {
        return this.addContext(key.get(), value);
    }

    default public <T> CauseStackManager addContext(Supplier<? extends EventContextKey<T>> key, Supplier<? extends T> value) {
        return this.addContext(key.get(), value.get());
    }

    public <T> Optional<T> getContext(EventContextKey<T> var1);

    default public <T> Optional<T> getContext(Supplier<? extends EventContextKey<T>> key) {
        return this.getContext(key.get());
    }

    default public <T> T requireContext(EventContextKey<T> key) {
        Optional<T> optional = this.getContext(key);
        if (optional.isPresent()) {
            return optional.get();
        }
        throw new NoSuchElementException(String.format("Could not retrieve value for key '%s'", key.toString()));
    }

    default public <T> T requireContext(Supplier<? extends EventContextKey<T>> key) {
        Optional<T> optional = this.getContext(key.get());
        if (optional.isPresent()) {
            return optional.get();
        }
        throw new NoSuchElementException(String.format("Could not retrieve value for key '%s'", key.get().toString()));
    }

    public <T> Optional<T> removeContext(EventContextKey<T> var1);

    default public <T> Optional<T> removeContext(Supplier<? extends EventContextKey<T>> key) {
        return this.removeContext(key.get());
    }

    public static interface StackFrame
    extends AutoCloseable {
        public Cause getCurrentCause();

        public EventContext getCurrentContext();

        public StackFrame pushCause(Object var1);

        public Object popCause();

        public <T> StackFrame addContext(EventContextKey<T> var1, T var2);

        default public <T> StackFrame addContext(EventContextKey<T> key, Supplier<? extends T> value) {
            return this.addContext(key, value.get());
        }

        default public <T> StackFrame addContext(Supplier<? extends EventContextKey<T>> key, T value) {
            return this.addContext(key.get(), value);
        }

        default public <T> StackFrame addContext(Supplier<? extends EventContextKey<T>> key, Supplier<? extends T> value) {
            return this.addContext(key.get(), value.get());
        }

        public <T> Optional<T> removeContext(EventContextKey<T> var1);

        default public <T> Optional<T> removeContext(Supplier<? extends EventContextKey<T>> key) {
            return this.removeContext(key.get());
        }

        @Override
        public void close();
    }
}

