/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.cause.entity.damage;

import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.DoubleUnaryOperator;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.cause.entity.damage.DamageModifier;
import org.spongepowered.api.event.cause.entity.damage.ModifierFunction;

public class DamageFunction
implements ModifierFunction<DamageModifier> {
    public static final DoubleUnaryOperator ZERO_DAMAGE = value -> 0.0;
    private final DamageModifier modifier;
    private final DoubleUnaryOperator function;

    public static DamageFunction of(DamageModifier first, DoubleUnaryOperator second) {
        return new DamageFunction(first, second);
    }

    public DamageFunction(DamageModifier modifier) {
        this(modifier, ZERO_DAMAGE);
    }

    public DamageFunction(DamageModifier modifier, DoubleUnaryOperator function) {
        this.modifier = Objects.requireNonNull(modifier, "modifier");
        this.function = Objects.requireNonNull(function, "function");
    }

    @Override
    public DamageModifier getModifier() {
        return this.modifier;
    }

    @Override
    public DoubleUnaryOperator getFunction() {
        return this.function;
    }

    public String toString() {
        return new StringJoiner(",", DamageFunction.class.getSimpleName() + "[", "]").add("modifier=" + this.getModifier()).add("function=" + this.getFunction()).toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DamageFunction that = (DamageFunction)o;
        return Objects.equals(this.modifier, that.modifier) && Objects.equals(this.function, that.function);
    }

    public int hashCode() {
        return Objects.hash(this.modifier, this.function);
    }
}

