/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.cause.entity.damage.source;

import java.util.function.Supplier;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.cause.entity.damage.DamageType;
import org.spongepowered.api.util.CopyableBuilder;

public interface DamageSource {
    public static Builder builder() {
        return Sponge.getRegistry().getBuilderRegistry().provideBuilder(Builder.class);
    }

    public DamageType getType();

    public boolean isAbsolute();

    public boolean isBypassingArmor();

    public boolean isScaledByDifficulty();

    public boolean isExplosive();

    public boolean isMagic();

    public boolean doesAffectCreative();

    public boolean isFire();

    public double getExhaustion();

    public static interface DamageSourceBuilder<T extends DamageSource, B extends DamageSourceBuilder<T, B>>
    extends CopyableBuilder<T, B> {
        public B fire();

        public B scalesWithDifficulty();

        public B bypassesArmor();

        public B explosion();

        public B absolute();

        public B magical();

        public B creative();

        public B exhaustion(double var1);

        default public B type(Supplier<? extends DamageType> damageType) {
            return this.type(damageType.get());
        }

        public B type(DamageType var1);

        public T build() throws IllegalStateException;
    }

    public static interface Builder
    extends DamageSourceBuilder<DamageSource, Builder> {
    }
}

