/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.inventory;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.DataHolderBuilder;
import org.spongepowered.api.data.SerializableDataHolder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.entity.attribute.AttributeModifier;
import org.spongepowered.api.entity.attribute.type.AttributeType;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;

public interface ItemStack
extends SerializableDataHolder.Mutable {
    public static Builder builder() {
        return Sponge.getRegistry().getBuilderRegistry().provideBuilder(Builder.class);
    }

    public static ItemStack of(Supplier<? extends ItemType> itemType, int quantity) {
        return ItemStack.of(itemType.get(), quantity);
    }

    public static ItemStack of(ItemType itemType, int quantity) {
        return ItemStack.builder().itemType(itemType).quantity(quantity).build();
    }

    public static ItemStack of(Supplier<? extends ItemType> itemType) {
        return ItemStack.of(itemType.get());
    }

    public static ItemStack of(ItemType itemType) {
        return ItemStack.of(itemType, 1);
    }

    public static ItemStack empty() {
        return ItemStack.builder().itemType(ItemTypes.AIR).build();
    }

    public ItemType getType();

    public int getQuantity();

    public void setQuantity(int var1) throws IllegalArgumentException;

    public int getMaxStackQuantity();

    public ItemStackSnapshot createSnapshot();

    public boolean equalTo(ItemStack var1);

    public boolean isEmpty();

    default public Collection<AttributeModifier> getAttributeModifiers(Supplier<? extends AttributeType> attributeType, Supplier<? extends EquipmentType> equipmentType) {
        return this.getAttributeModifiers(attributeType.get(), equipmentType.get());
    }

    default public Collection<AttributeModifier> getAttributeModifiers(AttributeType attributeType, Supplier<? extends EquipmentType> equipmentType) {
        return this.getAttributeModifiers(attributeType, equipmentType.get());
    }

    default public Collection<AttributeModifier> getAttributeModifiers(Supplier<? extends AttributeType> attributeType, EquipmentType equipmentType) {
        return this.getAttributeModifiers(attributeType.get(), equipmentType);
    }

    public Collection<AttributeModifier> getAttributeModifiers(AttributeType var1, EquipmentType var2);

    default public void addAttributeModifier(Supplier<? extends AttributeType> attributeType, AttributeModifier modifier, EquipmentType equipmentType) {
        this.addAttributeModifier(attributeType.get(), modifier, equipmentType);
    }

    default public void addAttributeModifier(AttributeType attributeType, AttributeModifier modifier, Supplier<? extends EquipmentType> equipmentType) {
        this.addAttributeModifier(attributeType, modifier, equipmentType.get());
    }

    default public void addAttributeModifier(Supplier<? extends AttributeType> attributeType, AttributeModifier modifier, Supplier<? extends EquipmentType> equipmentType) {
        this.addAttributeModifier(attributeType.get(), modifier, equipmentType.get());
    }

    public void addAttributeModifier(AttributeType var1, AttributeModifier var2, EquipmentType var3);

    @Override
    public ItemStack copy();

    public static interface Builder
    extends DataHolderBuilder.Mutable<ItemStack, Builder> {
        public Builder itemType(ItemType var1);

        default public Builder itemType(Supplier<? extends ItemType> itemType) {
            return this.itemType(itemType.get());
        }

        public ItemType getCurrentItem();

        public Builder quantity(int var1) throws IllegalArgumentException;

        public Builder fromItemStack(ItemStack var1);

        default public Builder attributeModifier(Supplier<? extends AttributeType> attributeType, AttributeModifier modifier, Supplier<? extends EquipmentType> equipmentType) {
            return this.attributeModifier(attributeType.get(), modifier, equipmentType.get());
        }

        public Builder attributeModifier(AttributeType var1, AttributeModifier var2, EquipmentType var3);

        default public Builder fromBlockState(BlockState blockState) {
            Objects.requireNonNull(blockState);
            BlockType blockType = blockState.getType();
            this.itemType(blockType.getItem().orElseThrow(() -> new IllegalArgumentException("Missing valid ItemType for BlockType: " + blockType.getKey().toString())));
            blockState.getValues().forEach(this::add);
            return this;
        }

        default public Builder fromBlockState(Supplier<? extends BlockState> blockState) {
            Objects.requireNonNull(blockState);
            BlockType blockType = blockState.get().getType();
            this.itemType(blockType.getItem().orElseThrow(() -> new IllegalArgumentException("Missing valid ItemType for BlockType: " + blockType.getKey().toString())));
            blockState.get().getValues().forEach(this::add);
            return this;
        }

        public Builder fromContainer(DataView var1);

        default public Builder fromSnapshot(ItemStackSnapshot snapshot) {
            return this.fromItemStack(snapshot.createStack());
        }

        public Builder fromBlockSnapshot(BlockSnapshot var1);

        default public Builder apply(Predicate<Builder> predicate, Consumer<Builder> consumer) {
            if (predicate.test(this)) {
                consumer.accept(this);
            }
            return this;
        }

        @Override
        public ItemStack build() throws IllegalStateException;
    }
}

