/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.recipe.cooking;

import java.util.Optional;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.Recipe;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.item.recipe.RecipeType;
import org.spongepowered.api.item.recipe.cooking.CookingResult;
import org.spongepowered.api.item.recipe.crafting.Ingredient;
import org.spongepowered.api.util.CatalogBuilder;

public interface CookingRecipe
extends Recipe {
    public static Builder builder() {
        return Sponge.getRegistry().getBuilderRegistry().provideBuilder(Builder.class);
    }

    public Ingredient getIngredient();

    public boolean isValid(ItemStackSnapshot var1);

    public Optional<CookingResult> getResult(ItemStackSnapshot var1);

    public int getCookingTime();

    public float getExperience();

    public static interface Builder
    extends CatalogBuilder<RecipeRegistration, Builder> {
        public IngredientStep type(RecipeType<CookingRecipe> var1);

        default public IngredientStep type(Supplier<RecipeType<CookingRecipe>> type) {
            return this.type(type.get());
        }

        public static interface EndStep
        extends Builder,
        CatalogBuilder<RecipeRegistration, Builder> {
            public EndStep group(@Nullable String var1);

            public EndStep experience(double var1);

            public EndStep cookingTime(int var1);
        }

        public static interface ResultStep
        extends Builder {
            public EndStep result(ItemType var1);

            default public EndStep result(Supplier<ItemType> result) {
                return this.result(result.get());
            }

            public EndStep result(ItemStack var1);

            public EndStep result(ItemStackSnapshot var1);
        }

        public static interface IngredientStep
        extends Builder {
            public ResultStep ingredient(Ingredient var1);

            default public ResultStep ingredient(ItemType ingredient) {
                return this.ingredient(Ingredient.of(ingredient));
            }

            default public ResultStep ingredient(Supplier<ItemType> ingredient) {
                return this.ingredient(ingredient.get());
            }
        }
    }
}

